/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2;

import io.r2dbc.h2.CommandUtil;
import io.r2dbc.h2.H2DatabaseExceptionFactory;
import io.r2dbc.h2.H2Result;
import io.r2dbc.h2.client.Binding;
import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.codecs.Codecs;
import io.r2dbc.h2.util.Assert;
import io.r2dbc.spi.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.command.CommandInterface;
import org.h2.engine.GeneratedKeysMode;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import reactor.core.publisher.Flux;
import reactor.util.annotation.Nullable;

public final class H2Statement
implements Statement {
    private static final Pattern PARAMETER_SYMBOLS = Pattern.compile(".*([$?])([\\d]+).*");
    private static final int BIND_POSITION_NUMBER_GROUP = 2;
    private final Bindings bindings = new Bindings();
    private final Client client;
    private final Codecs codecs;
    private final String sql;
    private String[] generatedColumns;
    private boolean allGeneratedColumns = false;

    H2Statement(Client client, Codecs codecs, String sql) {
        this.client = Assert.requireNonNull(client, "client must not be null");
        this.codecs = Assert.requireNonNull(codecs, "codecs must not be null");
        this.sql = Assert.requireNonNull(sql, "sql must not be null");
    }

    public H2Statement add() {
        this.bindings.finish();
        this.bindings.open = true;
        return this;
    }

    public H2Statement bind(String name, Object value) {
        Assert.requireNonNull(name, "name must not be null");
        return this.addIndex(this.getIndex(name), value);
    }

    public H2Statement bind(int index, Object value) {
        return this.addIndex(index, value);
    }

    public H2Statement bindNull(String name, Class<?> type) {
        Assert.requireNonNull(name, "name must not be null");
        this.bindNull(this.getIndex(name), (Class)type);
        return this;
    }

    public H2Statement bindNull(int index, @Nullable Class<?> type) {
        this.bindings.open = false;
        this.bindings.getCurrent().add(index, this.codecs.encodeNull(type));
        return this;
    }

    public Flux<H2Result> execute() {
        Assert.requireTrue(!this.bindings.open, "No unfinished bindings!");
        return Flux.fromArray((Object[])this.sql.split(";")).flatMap(sql -> {
            if (this.generatedColumns == null) {
                return H2Statement.execute(this.client, sql.trim(), this.bindings, this.codecs, this.allGeneratedColumns);
            }
            return H2Statement.execute(this.client, sql.trim(), this.bindings, this.codecs, this.generatedColumns);
        });
    }

    public H2Statement returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        if (columns.length == 0) {
            this.allGeneratedColumns = true;
        } else {
            this.generatedColumns = columns;
        }
        return this;
    }

    Binding getCurrentBinding() {
        return this.bindings.getCurrent();
    }

    private H2Statement addIndex(int index, Object value) {
        Assert.requireNonNull(value, "value must not be null");
        this.bindings.open = false;
        this.bindings.getCurrent().add(index, this.codecs.encode(value));
        return this;
    }

    private static Flux<H2Result> execute(Client client, String sql, Bindings bindings, Codecs codecs, Object generatedColumns) {
        return Flux.fromIterable(() -> client.prepareCommand(sql, bindings.bindings)).map(command -> {
            try {
                if (command.isQuery()) {
                    ResultInterface result = client.query((CommandInterface)command);
                    CommandUtil.clearForReuse(command);
                    return H2Result.toResult(codecs, result, null);
                }
                ResultWithGeneratedKeys result = client.update((CommandInterface)command, generatedColumns);
                CommandUtil.clearForReuse(command);
                if (GeneratedKeysMode.valueOf((Object)generatedColumns) == 0) {
                    return H2Result.toResult(codecs, result.getUpdateCount());
                }
                return H2Result.toResult(codecs, result.getGeneratedKeys(), result.getUpdateCount());
            }
            catch (DbException e) {
                throw H2DatabaseExceptionFactory.convert(e);
            }
        });
    }

    private int getIndex(String identifier) {
        Matcher matcher = PARAMETER_SYMBOLS.matcher(identifier);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format("Identifier '%s' is not a valid identifier. Should be of the pattern '%s'.", identifier, PARAMETER_SYMBOLS.pattern()));
        }
        return Integer.parseInt(matcher.group(2)) - 1;
    }

    private static final class Bindings {
        private final List<Binding> bindings = new ArrayList<Binding>();
        private Binding current;
        private boolean open = false;

        private Bindings() {
        }

        public boolean isOpen() {
            return this.open;
        }

        public String toString() {
            return "Bindings{bindings=" + this.bindings + ", current=" + this.current + '}';
        }

        private void finish() {
            this.current = null;
            this.open = false;
        }

        private Binding getCurrent() {
            if (this.current == null) {
                this.current = new Binding();
                this.bindings.add(this.current);
            }
            return this.current;
        }
    }
}

