/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorexclient.builder;

import io.github.javpower.vectorexclient.req.CollectionDataPageReq;
import io.github.javpower.vectorexclient.req.ConditionFiledReq;
import java.util.ArrayList;
import java.util.List;

public class QueryBuilder<T> {
    private String collectionName;
    private List<ConditionFiledReq> conditions = new ArrayList<ConditionFiledReq>();
    private List<Float> vector;
    private String textVector;
    private String vectorFieldName;
    private Integer topK;
    private Integer pageIndex;
    private Integer pageSize;

    public QueryBuilder(String collectionName) {
        this.collectionName = collectionName;
    }

    public static QueryBuilder lambda(String collectionName) {
        QueryBuilder builder = new QueryBuilder(collectionName);
        return builder;
    }

    public QueryBuilder<T> eq(String fieldName, Object value) {
        this.conditions.add(this.createCondition("eq", fieldName, value));
        return this;
    }

    public QueryBuilder<T> in(String fieldName, List<?> values) {
        this.conditions.add(this.createCondition("in", fieldName, values));
        return this;
    }

    public QueryBuilder<T> like(String fieldName, String value) {
        this.conditions.add(this.createCondition("like", fieldName, value));
        return this;
    }

    public QueryBuilder<T> between(String fieldName, Comparable start, Comparable end) {
        ConditionFiledReq condition = this.createCondition("between", fieldName, null);
        condition.setStart(start);
        condition.setEnd(end);
        this.conditions.add(condition);
        return this;
    }

    public QueryBuilder<T> gt(String fieldName, Comparable value) {
        this.conditions.add(this.createCondition("gt", fieldName, value));
        return this;
    }

    public QueryBuilder<T> lt(String fieldName, Comparable value) {
        this.conditions.add(this.createCondition("lt", fieldName, value));
        return this;
    }

    public QueryBuilder<T> ge(String fieldName, Comparable value) {
        this.conditions.add(this.createCondition("ge", fieldName, value));
        return this;
    }

    public QueryBuilder<T> le(String fieldName, Comparable value) {
        this.conditions.add(this.createCondition("le", fieldName, value));
        return this;
    }

    public QueryBuilder<T> and(QueryBuilder<T> other) {
        this.conditions.add(this.createNestedCondition("and", other.conditions));
        return this;
    }

    public QueryBuilder<T> or(QueryBuilder<T> other) {
        this.conditions.add(this.createNestedCondition("or", other.conditions));
        return this;
    }

    private ConditionFiledReq createCondition(String operator, String field, Object value) {
        ConditionFiledReq condition = new ConditionFiledReq();
        condition.setOperator(operator);
        condition.setField(field);
        condition.setValue(value);
        return condition;
    }

    public QueryBuilder<T> vector(String vectorFieldName, List<Float> vector) {
        this.vectorFieldName = vectorFieldName;
        this.vector = vector;
        return this;
    }

    public QueryBuilder<T> textVector(String vectorFieldName, String textVector) {
        this.vectorFieldName = vectorFieldName;
        this.textVector = textVector;
        return this;
    }

    public QueryBuilder<T> topK(Integer topK) {
        this.topK = topK;
        return this;
    }

    public QueryBuilder<T> page(Integer pageIndex, Integer pageSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        return this;
    }

    public CollectionDataPageReq build() {
        CollectionDataPageReq req = new CollectionDataPageReq();
        req.setCollectionName(this.collectionName);
        req.setQuery(this.conditions);
        req.setVector(this.vector);
        req.setTextVector(this.textVector);
        req.setVectorFieldName(this.vectorFieldName);
        req.setTopK(this.topK);
        req.setPageIndex(this.pageIndex);
        req.setPageSize(this.pageSize);
        return req;
    }

    private ConditionFiledReq createNestedCondition(String operator, List<ConditionFiledReq> nestedConditions) {
        ConditionFiledReq condition = new ConditionFiledReq();
        condition.setOperator(operator);
        condition.setConditionFiledReq(nestedConditions);
        return condition;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<ConditionFiledReq> getConditions() {
        return this.conditions;
    }

    public List<Float> getVector() {
        return this.vector;
    }

    public String getTextVector() {
        return this.textVector;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setConditions(List<ConditionFiledReq> conditions) {
        this.conditions = conditions;
    }

    public void setVector(List<Float> vector) {
        this.vector = vector;
    }

    public void setTextVector(String textVector) {
        this.textVector = textVector;
    }

    public void setVectorFieldName(String vectorFieldName) {
        this.vectorFieldName = vectorFieldName;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryBuilder)) {
            return false;
        }
        QueryBuilder other = (QueryBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Integer this$pageIndex = this.getPageIndex();
        Integer other$pageIndex = other.getPageIndex();
        if (this$pageIndex == null ? other$pageIndex != null : !((Object)this$pageIndex).equals(other$pageIndex)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        List<ConditionFiledReq> this$conditions = this.getConditions();
        List<ConditionFiledReq> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<Float> this$vector = this.getVector();
        List<Float> other$vector = other.getVector();
        if (this$vector == null ? other$vector != null : !((Object)this$vector).equals(other$vector)) {
            return false;
        }
        String this$textVector = this.getTextVector();
        String other$textVector = other.getTextVector();
        if (this$textVector == null ? other$textVector != null : !this$textVector.equals(other$textVector)) {
            return false;
        }
        String this$vectorFieldName = this.getVectorFieldName();
        String other$vectorFieldName = other.getVectorFieldName();
        return !(this$vectorFieldName == null ? other$vectorFieldName != null : !this$vectorFieldName.equals(other$vectorFieldName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Integer $pageIndex = this.getPageIndex();
        result = result * 59 + ($pageIndex == null ? 43 : ((Object)$pageIndex).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        List<ConditionFiledReq> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<Float> $vector = this.getVector();
        result = result * 59 + ($vector == null ? 43 : ((Object)$vector).hashCode());
        String $textVector = this.getTextVector();
        result = result * 59 + ($textVector == null ? 43 : $textVector.hashCode());
        String $vectorFieldName = this.getVectorFieldName();
        result = result * 59 + ($vectorFieldName == null ? 43 : $vectorFieldName.hashCode());
        return result;
    }

    public String toString() {
        return "QueryBuilder(collectionName=" + this.getCollectionName() + ", conditions=" + this.getConditions() + ", vector=" + this.getVector() + ", textVector=" + this.getTextVector() + ", vectorFieldName=" + this.getVectorFieldName() + ", topK=" + this.getTopK() + ", pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ")";
    }
}

