/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.llm.client.OkHttpClientUtil;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpNode
extends BaseNode {
    private String url;
    private String method;
    private List<Parameter> headers;
    private List<Parameter> urlParameters;
    private String bodyType;
    private List<Parameter> fromData;
    private List<Parameter> fromUrlencoded;
    private String bodyJson;
    private String rawBody;

    public static String mapToQueryString(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : map.keySet()) {
            if (StringUtil.noText((String)key)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(key.trim());
            stringBuilder.append("=");
            Object value = map.get(key);
            stringBuilder.append(value == null ? "" : HttpNode.urlEncode(value.toString().trim()));
        }
        return stringBuilder.toString();
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Parameter> headers) {
        this.headers = headers;
    }

    public List<Parameter> getUrlParameters() {
        return this.urlParameters;
    }

    public void setUrlParameters(List<Parameter> urlParameters) {
        this.urlParameters = urlParameters;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public List<Parameter> getFromData() {
        return this.fromData;
    }

    public void setFromData(List<Parameter> fromData) {
        this.fromData = fromData;
    }

    public List<Parameter> getFromUrlencoded() {
        return this.fromUrlencoded;
    }

    public void setFromUrlencoded(List<Parameter> fromUrlencoded) {
        this.fromUrlencoded = fromUrlencoded;
    }

    public String getBodyJson() {
        return this.bodyJson;
    }

    public void setBodyJson(String bodyJson) {
        this.bodyJson = bodyJson;
    }

    public String getRawBody() {
        return this.rawBody;
    }

    public void setRawBody(String rawBody) {
        this.rawBody = rawBody;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object> execute(Chain chain) {
        Map urlDataMap = chain.getParameterValues((ChainNode)this, this.urlParameters);
        String parametersString = HttpNode.mapToQueryString(urlDataMap);
        String newUrl = "POST".equalsIgnoreCase(this.method) || parametersString.isEmpty() ? this.url : this.url + (this.url.contains("?") ? "&" + parametersString : "?" + parametersString);
        Request.Builder reqBuilder = new Request.Builder().url(newUrl);
        Map headersMap = chain.getParameterValues((ChainNode)this, this.headers);
        headersMap.forEach((s, o) -> reqBuilder.addHeader(s, String.valueOf(o)));
        if (StringUtil.noText((String)this.method) || "GET".equalsIgnoreCase(this.method)) {
            reqBuilder.method("GET", null);
        } else {
            reqBuilder.method(this.method.toUpperCase(), this.getRequestBody(chain, urlDataMap));
        }
        OkHttpClient okHttpClient = OkHttpClientUtil.buildDefaultClient();
        try (Response response = okHttpClient.newCall(reqBuilder.build()).execute();){
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("statusCode", response.code());
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (String name : response.headers().names()) {
                responseHeaders.put(name, response.header(name));
            }
            result.put("headers", responseHeaders);
            ResponseBody body = response.body();
            String bodyString = null;
            if (body != null) {
                bodyString = body.string();
            }
            if (StringUtil.hasText(bodyString)) {
                DataType outDataType = null;
                List outputDefs = this.getOutputDefs();
                if (outputDefs != null) {
                    for (Parameter outputDef : outputDefs) {
                        if (!"body".equalsIgnoreCase(outputDef.getName())) continue;
                        outDataType = outputDef.getDataType();
                        break;
                    }
                }
                if (outDataType != null && (outDataType == DataType.Object || outDataType.getValue().startsWith("Array"))) {
                    result.put("body", JSON.parse((String)bodyString));
                } else {
                    result.put("body", bodyString);
                }
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RequestBody getRequestBody(Chain chain, Map<String, Object> urlDataMap) {
        if ("json".equals(this.bodyType)) {
            JSONObject object = JSON.parseObject((String)this.bodyJson);
            object.putAll(urlDataMap);
            return RequestBody.create((String)JSON.toJSONString((Object)object), (MediaType)MediaType.parse((String)"application/json"));
        }
        if ("x-www-form-urlencoded".equals(this.bodyType)) {
            Map formUrlencodedMap = chain.getParameterValues((ChainNode)this, this.fromUrlencoded);
            String bodyString = HttpNode.mapToQueryString(formUrlencodedMap);
            return RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"));
        }
        if ("form-data".equals(this.bodyType)) {
            Map formDataMap = chain.getParameterValues((ChainNode)this, this.fromData);
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            formDataMap.forEach((s, o) -> builder.addFormDataPart(s, String.valueOf(o)));
            return builder.build();
        }
        if ("raw".equals(this.bodyType)) {
            return RequestBody.create((String)this.rawBody, null);
        }
        return RequestBody.create((String)"", null);
    }

    public String toString() {
        return "HttpNode{url='" + this.url + '\'' + ", method='" + this.method + '\'' + ", headers=" + this.headers + ", parameters=" + this.urlParameters + ", bodyType='" + this.bodyType + '\'' + ", fromData=" + this.fromData + ", fromUrlencoded=" + this.fromUrlencoded + ", bodyJson='" + this.bodyJson + '\'' + ", rawBody='" + this.rawBody + '\'' + ", description='" + this.description + '\'' + ", parameter=" + this.urlParameters + ", outputDefs=" + this.outputDefs + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", async=" + this.async + ", inwardEdges=" + this.inwardEdges + ", outwardEdges=" + this.outwardEdges + ", condition=" + this.condition + ", memory=" + this.memory + ", nodeStatus=" + this.nodeStatus + '}';
    }
}

