/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import android.annotation.TargetApi;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;
import retrofit2.Retrofit;

@IgnoreJRERequirement
@TargetApi(value=24)
final class CompletableFutureCallAdapterFactory
extends CallAdapter.Factory {
    CompletableFutureCallAdapterFactory() {
    }

    @Override
    @Nullable
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (CompletableFutureCallAdapterFactory.getRawType(returnType) != CompletableFuture.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalStateException("CompletableFuture return type must be parameterized as CompletableFuture<Foo> or CompletableFuture<? extends Foo>");
        }
        Type innerType = CompletableFutureCallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)returnType);
        if (CompletableFutureCallAdapterFactory.getRawType(innerType) != Response.class) {
            return new BodyCallAdapter(innerType);
        }
        if (!(innerType instanceof ParameterizedType)) {
            throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
        }
        Type responseType = CompletableFutureCallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)innerType);
        return new ResponseCallAdapter(responseType);
    }

    @IgnoreJRERequirement
    private static final class CallCancelCompletableFuture<T>
    extends CompletableFuture<T> {
        private final Call<?> call;

        CallCancelCompletableFuture(Call<?> call) {
            this.call = call;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning) {
                this.call.cancel();
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }

    @IgnoreJRERequirement
    private static final class ResponseCallAdapter<R>
    implements CallAdapter<R, CompletableFuture<Response<R>>> {
        private final Type responseType;

        ResponseCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        @Override
        public Type responseType() {
            return this.responseType;
        }

        @Override
        public CompletableFuture<Response<R>> adapt(Call<R> call) {
            CallCancelCompletableFuture future = new CallCancelCompletableFuture(call);
            call.enqueue(new ResponseCallback(future));
            return future;
        }

        @IgnoreJRERequirement
        private class ResponseCallback
        implements Callback<R> {
            private final CompletableFuture<Response<R>> future;

            public ResponseCallback(CompletableFuture<Response<R>> future) {
                this.future = future;
            }

            @Override
            public void onResponse(Call<R> call, Response<R> response) {
                this.future.complete(response);
            }

            @Override
            public void onFailure(Call<R> call, Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }

    @IgnoreJRERequirement
    private static final class BodyCallAdapter<R>
    implements CallAdapter<R, CompletableFuture<R>> {
        private final Type responseType;

        BodyCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        @Override
        public Type responseType() {
            return this.responseType;
        }

        @Override
        public CompletableFuture<R> adapt(Call<R> call) {
            CallCancelCompletableFuture future = new CallCancelCompletableFuture(call);
            call.enqueue(new BodyCallback(future));
            return future;
        }

        @IgnoreJRERequirement
        private class BodyCallback
        implements Callback<R> {
            private final CompletableFuture<R> future;

            public BodyCallback(CompletableFuture<R> future) {
                this.future = future;
            }

            @Override
            public void onResponse(Call<R> call, Response<R> response) {
                if (response.isSuccessful()) {
                    this.future.complete(response.body());
                } else {
                    this.future.completeExceptionally(new HttpException(response));
                }
            }

            @Override
            public void onFailure(Call<R> call, Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }
}

