/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.driver.oauth.AccessTokenCache;
import oracle.jdbc.driver.oauth.JsonWebToken;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;

final class IamDataplaneClient {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("E, dd MMM uuuu HH:mm:ss z", Locale.US);
    private static final int CACHES_SIZE = 128;
    private static final Map<Builder, AccessTokenCache<JsonWebToken>> CACHES = Collections.synchronizedMap(new LinkedHashMap<Builder, AccessTokenCache<JsonWebToken>>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Builder, AccessTokenCache<JsonWebToken>> entry) {
            return this.size() > 128;
        }
    });

    IamDataplaneClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Blind
    private static JsonWebToken requestBearerToken(Builder builder) throws IOException {
        URL url = new URL(builder.endPoint);
        if (!"https".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException("Protocol of endpoint is not https: " + url.getProtocol());
        }
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setSSLSocketFactory(CustomSSLSocketFactory.getSSLSocketFactory(builder.tlsConfig, null, CommonDiagnosable.getInstance()));
        connection.setRequestProperty("Date", ZonedDateTime.now(ZoneId.of("Z")).format(DATE_FORMATTER));
        connection.setRequestProperty("Authorization", IamDataplaneClient.createAuthorization(builder.user, builder.password));
        connection.setDoOutput(true);
        try (OutputStream request = connection.getOutputStream();){
            request.write(String.format("{\"scope\": \"urn:oracle:db::id::%s\", \"tenantId\": \"%s\"}", builder.compartment == null ? "*" : (builder.database == null ? builder.compartment : builder.compartment + "::" + builder.database), builder.tenancy).getBytes(StandardCharsets.UTF_8));
            request.flush();
        }
        try {
            var4_6 = null;
            try (InputStream response = connection.getInputStream();){
                JsonWebToken jsonWebToken;
                String token2 = new OracleJsonFactory().createJsonTextValue(response).asJsonObject().getString("token");
                if (token2 == null) {
                    throw new IOException("JSON response does not contain a token");
                }
                char[] tokenChars = token2.toCharArray();
                try {
                    jsonWebToken = JsonWebToken.createBearerToken(tokenChars);
                }
                catch (Throwable throwable) {
                    try {
                        Arrays.fill(tokenChars, '\u0000');
                        throw throwable;
                    }
                    catch (Throwable token2) {
                        var4_6 = token2;
                        throw token2;
                    }
                }
                Arrays.fill(tokenChars, '\u0000');
                return jsonWebToken;
            }
        }
        catch (OracleJsonException jsonException) {
            throw new IOException("JSON parsing failure", jsonException);
        }
        catch (IOException ioException) {
            String opcRequestId;
            StringBuilder messageBuilder = new StringBuilder();
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));){
                    String errorResponse = errorReader.lines().collect(Collectors.joining("\n"));
                    messageBuilder.append(errorResponse);
                }
            }
            if ((opcRequestId = connection.getHeaderField("opc-request-id")) != null) {
                messageBuilder.append("\n(opc-request-id: " + opcRequestId + ")");
            }
            if (messageBuilder.length() == 0) {
                throw ioException;
            }
            throw new IOException(messageBuilder.toString(), ioException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static String createAuthorization(String user, @Blind OpaqueString password) {
        byte[] userColonBytes = (user + ":").getBytes(StandardCharsets.UTF_8);
        ByteBuffer passwordBuffer = password.map(chars -> StandardCharsets.UTF_8.encode(CharBuffer.wrap(chars)));
        try {
            String string;
            byte[] userColonPassword = new byte[userColonBytes.length + passwordBuffer.remaining()];
            try {
                System.arraycopy(userColonBytes, 0, userColonPassword, 0, userColonBytes.length);
                passwordBuffer.get(userColonPassword, userColonBytes.length, passwordBuffer.remaining());
                string = "Basic " + Base64.getEncoder().encodeToString(userColonPassword);
            }
            catch (Throwable throwable) {
                Arrays.fill(userColonPassword, (byte)0);
                throw throwable;
            }
            Arrays.fill(userColonPassword, (byte)0);
            return string;
        }
        finally {
            passwordBuffer.clear();
            passwordBuffer.put(new byte[passwordBuffer.remaining()]);
        }
    }

    static Builder requestBuilder() {
        return new Builder();
    }

    static final class Builder {
        private String endPoint;
        private String tenancy;
        private String compartment;
        private String database;
        private String user;
        private OpaqueString password;
        private Properties tlsConfig;

        private Builder() {
        }

        Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        Builder compartment(String compartment) {
            this.compartment = compartment;
            return this;
        }

        Builder database(String database) {
            this.database = database;
            return this;
        }

        Builder user(String user) {
            this.user = user;
            return this;
        }

        Builder password(@Blind OpaqueString password) {
            this.password = password;
            return this;
        }

        Builder tlsConfig(Properties tlsConfig) {
            this.tlsConfig = (Properties)tlsConfig.clone();
            this.tlsConfig.put((Object)41, "true");
            return this;
        }

        @Blind
        JsonWebToken build() throws IOException {
            try {
                return (JsonWebToken)CACHES.computeIfAbsent(this, this0 -> JsonWebToken.createCache(() -> {
                    try {
                        return IamDataplaneClient.requestBearerToken(this);
                    }
                    catch (IOException ioException) {
                        throw new UncheckedIOException(ioException);
                    }
                })).get();
            }
            catch (UncheckedIOException ioException) {
                throw ioException.getCause();
            }
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Builder && Objects.equals(this.endPoint, ((Builder)object).endPoint) && Objects.equals(this.tenancy, ((Builder)object).tenancy) && Objects.equals(this.compartment, ((Builder)object).compartment) && Objects.equals(this.database, ((Builder)object).database) && Objects.equals(this.user, ((Builder)object).user) && Objects.equals(this.password, ((Builder)object).password) && Objects.equals(this.tlsConfig, ((Builder)object).tlsConfig);
        }

        public int hashCode() {
            return Objects.hash(this.endPoint, this.tenancy, this.compartment, this.database, this.user, this.password, this.tlsConfig);
        }
    }
}

