/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.CancelState;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;

class CancelLock
implements Diagnosable {
    private static final String CLASS_NAME = CancelLock.class.getName();
    private CancelState state = null;
    private OracleStatement statement = null;

    CancelLock(OracleStatement stmt) {
        this.statement = stmt;
        this.state = new CancelState();
    }

    boolean isIdle() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            boolean bl = this.state.isIdle();
            return bl;
        }
    }

    boolean isCanceled() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            boolean bl = this.state.isCanceled();
            return bl;
        }
    }

    void enterExecuting() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            assert (this.state.isIdle());
            this.state.setExecuting();
        }
    }

    /*
     * Unable to fully structure code
     */
    void exitExecuting() {
        while (true) lbl-1000:
        // 7 sources

        {
            block28: {
                block26: {
                    block27: {
                        lock = this.state.acquireCloseableLock();
                        var2_2 = null;
                        if (!this.state.isExecuting()) break block26;
                        this.state.setIdle();
                        if (lock == null) break;
                        if (var2_2 == null) break block27;
                        try {
                            lock.close();
                        }
                        catch (Throwable var3_4) {
                            var2_2.addSuppressed(var3_4);
                        }
                        break;
                    }
                    lock.close();
                    break;
                }
                if (!this.state.isCanceling()) break block28;
                try {
                    this.state.monitorWait();
                }
                finally {
                    if (lock == null) ** GOTO lbl-1000
                    if (var2_2 != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable var3_5) {
                            var2_2.addSuppressed(var3_5);
                        }
                    }
                    lock.close();
                }
            }
            try {
                if (!this.state.isCanceled()) continue;
                if (this.statement != null && this.statement.connection.cancelInProgressFlag) {
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CancelLock.CLASS_NAME, "exitExecuting", "Cancel still in progress ...", null, null);
                }
                this.state.setIdle();
            }
            catch (Throwable var3_9) {
                var2_2 = var3_9;
                throw var3_9;
            }
            catch (Throwable var5_11) {
                throw var5_11;
            }
            finally {
                if (lock == null) continue;
                if (var2_2 != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable var3_7) {
                        var2_2.addSuppressed(var3_7);
                    }
                    continue;
                }
                lock.close();
                continue;
            }
            break;
        }
    }

    boolean enterCanceling() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            if (this.state.isExecuting()) {
                this.state.setCanceling();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    void exitCanceling() {
        try (Monitor.CloseableLock lock = this.state.acquireCloseableLock();){
            assert (this.state.isCanceling());
            this.state.setCanceled();
            this.state.monitorNotify();
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.statement.getDiagnosable();
    }
}

