/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.bspay.sdk.opps.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.BasePay;
import com.huifu.bspay.sdk.opps.core.exception.BasePayException;
import com.huifu.bspay.sdk.opps.core.exception.FailureCode;
import com.huifu.bspay.sdk.opps.core.net.BasePayRequest;
import com.huifu.bspay.sdk.opps.core.request.BaseRequest;
import com.huifu.bspay.sdk.opps.core.utils.ObjectUtils;
import com.huifu.bspay.sdk.opps.core.utils.StringUtil;
import java.io.File;
import java.util.Map;

public class BasePayClient {
    public static Map<String, Object> request(BaseRequest request) throws BasePayException, IllegalAccessException {
        return BasePayClient.request(request, request.getFunctionCode().getCode(), false);
    }

    public static Map<String, Object> request(BaseRequest request, boolean isPage) throws BasePayException, IllegalAccessException {
        return BasePayClient.request(request, request.getFunctionCode().getCode(), isPage);
    }

    public static Map<String, Object> request(BaseRequest request, String funcCode, boolean isPage) throws BasePayException, IllegalAccessException {
        return BasePayClient.request(request, funcCode, null, isPage);
    }

    public static Map<String, Object> request(BaseRequest request, String funcCode, String merchantKey, boolean isPage) throws BasePayException, IllegalAccessException {
        Map<String, Object> params = ObjectUtils.objectToMap(request);
        if (request.getExtendInfos() != null && request.getExtendInfos().size() > 0) {
            params.putAll(request.getExtendInfos());
        }
        return BasePayClient.request(params, funcCode, merchantKey, isPage);
    }

    public static Map<String, Object> request(Map<String, Object> params, String funcCode, boolean isPage) throws BasePayException {
        return BasePayClient.request(params, funcCode, null, isPage);
    }

    public static Map<String, Object> request(Map<String, Object> params, String funcCode, String merchantKey, boolean isPage) throws BasePayException {
        Object riskCheckInfo;
        if (StringUtil.isEmpty(funcCode)) {
            throw new BasePayException(FailureCode.REQUEST_PARAMETER_ERROR.getFailureCode(), "\u8bf7\u6307\u5b9a\u8981\u8c03\u7528\u7684\u63a5\u53e3\u7684\u529f\u80fd\u7f16\u7801");
        }
        if (params.containsKey("risk_check_data") && !((riskCheckInfo = params.get("risk_check_data")) instanceof String)) {
            params.put("risk_check_data", JSON.toJSONString((Object)riskCheckInfo));
        }
        String interfaceUrl = funcCode.replaceAll("\\.", "/");
        return BasePayRequest.requestBasePay(interfaceUrl, params, merchantKey, isPage);
    }

    public static Map<String, Object> upload(BaseRequest request, File file) throws BasePayException, IllegalAccessException {
        Map<String, Object> params = ObjectUtils.objectToMap(request);
        if (request.getExtendInfos() != null && request.getExtendInfos().size() > 0) {
            params.putAll(request.getExtendInfos());
        }
        if (BasePay.debug) {
            System.out.println(">>" + JSONObject.toJSONString(params));
        }
        return BasePayClient.upload(params, file, request.getFunctionCode().getCode(), null);
    }

    public static Map<String, Object> upload(Map<String, Object> params, File file, String funcCode) throws BasePayException {
        return BasePayClient.upload(params, file, funcCode, null);
    }

    public static Map<String, Object> upload(Map<String, Object> params, File file, String funcCode, String merchantKey) throws BasePayException {
        if (StringUtil.isEmpty(funcCode)) {
            throw new BasePayException(FailureCode.REQUEST_PARAMETER_ERROR.getFailureCode(), "\u8bf7\u6307\u5b9a\u8981\u8c03\u7528\u7684\u63a5\u53e3\u7684\u529f\u80fd\u7f16\u7801");
        }
        String interfaceUrl = funcCode.replaceAll("\\.", "/");
        return BasePayRequest.requestBasePay(interfaceUrl, params, file, "file", merchantKey, true);
    }
}

