/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.scripting.cjson;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

class Decode
extends OneArgFunction {
    private static final String JSON_NULL = "null";
    private final Gson gson = new Gson();

    Decode() {
    }

    public LuaValue call(LuaValue arg) {
        String toDecode = arg.checkstring().tojstring();
        if (Decode.isSurroundedByQuotes(toDecode)) {
            return LuaString.valueOf((String)Decode.cutQuotes(toDecode));
        }
        Object javaObject = this.toJavaObject(toDecode);
        if (javaObject instanceof String) {
            throw new IllegalArgumentException("Invalid JSON string");
        }
        return Decode.coerceToLuaValue(javaObject);
    }

    private static boolean isSurroundedByQuotes(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }

    private static String cutQuotes(String toDecode) {
        return toDecode.substring(1, toDecode.length() - 1);
    }

    private Object toJavaObject(String value) {
        if (Decode.isNull(value)) {
            return null;
        }
        if (Decode.isBoolean(value)) {
            return Boolean.parseBoolean(value);
        }
        if (Decode.isLong(value)) {
            return Long.parseLong(value);
        }
        if (Decode.isDouble(value)) {
            return Double.parseDouble(value);
        }
        return this.gson.fromJson(value, Object.class);
    }

    private static LuaValue coerceToLuaValue(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            LuaTable table = LuaValue.tableOf((int)list.size(), (int)0);
            for (int i = 0; i < list.size(); ++i) {
                table.set(i + 1, Decode.coerceToLuaValue(list.get(i)));
            }
            return table;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            LuaTable table = LuaValue.tableOf((int)0, (int)map.size());
            map.forEach((key, value) -> table.set(CoerceJavaToLua.coerce((Object)key), Decode.coerceToLuaValue(value)));
            return table;
        }
        return CoerceJavaToLua.coerce((Object)object);
    }

    private static boolean isBoolean(String value) {
        return Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value);
    }

    private static boolean isLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isNull(String value) {
        return value == null || JSON_NULL.equals(value);
    }
}

