/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@RedisCommand(value="lpos")
public class LPos
extends AbstractRedisOperation {
    private static final String RANK = "rank";
    private static final String COUNT = "count";
    private static final String MAXLEN = "maxlen";
    private int count;
    private int rank;
    private int maxLen;
    private boolean containsCount = false;

    public LPos(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        Slice element = this.params().get(1);
        RMList list = this.getListFromBaseOrCreateEmpty(key);
        List<Slice> storedData = list.getStoredData();
        this.parseArgs(storedData.size());
        LinkedList<Slice> result = new LinkedList<Slice>();
        int matches = 0;
        int start = this.rank > 0 ? 0 : storedData.size() - 1;
        int add = this.rank > 0 ? 1 : -1;
        int checkedValues = 0;
        for (int i = start; i < storedData.size() && i >= 0 && this.maxLen > checkedValues; i += add) {
            ++checkedValues;
            if (!storedData.get(i).equals(element) || ++matches < Math.abs(this.rank) || result.size() >= this.count) continue;
            result.add(Response.integer(i));
        }
        if (result.isEmpty()) {
            return Response.NULL;
        }
        return !this.containsCount ? (Slice)result.get(0) : Response.array(result);
    }

    private void parseArgs(int listSize) {
        Map<String, Slice> args = LPos.getArgsWithValues(this.params(), new HashSet<String>(Arrays.asList(RANK, COUNT, MAXLEN)));
        this.rank = Optional.ofNullable(args.get(RANK)).map(slice -> Integer.parseInt(slice.toString())).orElse(1);
        if (this.rank == 0) {
            throw new IllegalArgumentException("ERR RANK can't be zero:");
        }
        this.count = Optional.ofNullable(args.get(COUNT)).map(slice -> Integer.parseInt(slice.toString())).orElse(1);
        this.count = this.count == 0 ? listSize : this.count;
        this.containsCount = args.containsKey(COUNT);
        this.maxLen = Optional.ofNullable(args.get(MAXLEN)).map(slice -> Integer.parseInt(slice.toString())).orElse(0);
        this.maxLen = this.maxLen == 0 ? listSize : this.maxLen;
    }

    private static Map<String, Slice> getArgsWithValues(List<Slice> params, Set<String> argNames) {
        HashMap<String, Slice> argMap = new HashMap<String, Slice>();
        for (int i = 0; i < params.size(); ++i) {
            String parameter = params.get(i).toString().toLowerCase();
            if (!argNames.contains(parameter)) continue;
            if (++i == params.size()) {
                throw new IllegalArgumentException("Param " + parameter + " expected to have a value");
            }
            argMap.put(parameter, params.get(i));
        }
        return argMap;
    }
}

