/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.miniapp.config.storage;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedisBetterConfigImpl;
import com.binarywang.spring.starter.wxjava.miniapp.config.storage.AbstractWxMaConfigStorageConfiguration;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaProperties;
import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnProperty(prefix="wx.miniapp.config-storage", name={"type"}, havingValue="redistemplate")
@ConditionalOnClass(value={StringRedisTemplate.class})
public class WxMaInRedisTemplateConfigStorageConfiguration
extends AbstractWxMaConfigStorageConfiguration {
    private final WxMaProperties properties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxMaConfig.class})
    public WxMaConfig wxMaConfig() {
        WxMaRedisBetterConfigImpl config = this.getWxMaInRedisTemplateConfigStorage();
        return this.config((WxMaDefaultConfigImpl)config, this.properties);
    }

    private WxMaRedisBetterConfigImpl getWxMaInRedisTemplateConfigStorage() {
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        RedisTemplateWxRedisOps redisOps = new RedisTemplateWxRedisOps(redisTemplate);
        return new WxMaRedisBetterConfigImpl((WxRedisOps)redisOps, this.properties.getConfigStorage().getKeyPrefix());
    }

    public WxMaInRedisTemplateConfigStorageConfiguration(WxMaProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

