/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.example;

import com.github.binarywang.wxpay.bean.notify.SignatureHeader;
import com.github.binarywang.wxpay.bean.transfer.TransferBatchesRequest;
import com.github.binarywang.wxpay.bean.transfer.TransferBatchesResult;
import com.github.binarywang.wxpay.bean.transfer.TransferBillsCancelResult;
import com.github.binarywang.wxpay.bean.transfer.TransferBillsGetResult;
import com.github.binarywang.wxpay.bean.transfer.TransferBillsNotifyResult;
import com.github.binarywang.wxpay.bean.transfer.TransferBillsRequest;
import com.github.binarywang.wxpay.bean.transfer.TransferBillsResult;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.TransferService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import java.util.Arrays;

public class NewTransferApiExample {
    private final TransferService transferService;

    public NewTransferApiExample(WxPayConfig config) {
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(config);
        this.transferService = wxPayService.getTransferService();
    }

    public void transferExample() {
        try {
            TransferBillsRequest request = TransferBillsRequest.newBuilder().appid("wx1234567890123456").outBillNo("TRANSFER_" + System.currentTimeMillis()).transferSceneId("1005").openid("oUpF8uMuAJO_M2pxb1Q9zNjWeS6o").userName("\u5f20\u4e09").transferAmount(100).transferRemark("\u4f63\u91d1\u62a5\u916c").notifyUrl("https://your-domain.com/transfer/notify").userRecvPerception("Y").build();
            TransferBillsResult result = this.transferService.transferBills(request);
            System.out.println("=== \u8f6c\u8d26\u53d1\u8d77\u6210\u529f ===");
            System.out.println("\u5546\u6237\u5355\u53f7: " + result.getOutBillNo());
            System.out.println("\u5fae\u4fe1\u8f6c\u8d26\u5355\u53f7: " + result.getTransferBillNo());
            System.out.println("\u521b\u5efa\u65f6\u95f4: " + result.getCreateTime());
            System.out.println("\u72b6\u6001: " + result.getState());
            System.out.println("\u8df3\u8f6c\u9886\u53d6\u9875\u9762\u4fe1\u606f: " + result.getPackageInfo());
        }
        catch (WxPayException e) {
            System.err.println("\u8f6c\u8d26\u5931\u8d25: " + e.getMessage());
            System.err.println("\u9519\u8bef\u4ee3\u7801: " + e.getErrCode());
            System.err.println("\u9519\u8bef\u63cf\u8ff0: " + e.getErrCodeDes());
        }
    }

    public void queryByOutBillNoExample() {
        try {
            String outBillNo = "TRANSFER_1642567890123";
            TransferBillsGetResult result = this.transferService.getBillsByOutBillNo(outBillNo);
            System.out.println("=== \u67e5\u8be2\u8f6c\u8d26\u7ed3\u679c\uff08\u5546\u6237\u5355\u53f7\uff09===");
            System.out.println("\u5546\u6237\u5355\u53f7: " + result.getOutBillNo());
            System.out.println("\u5fae\u4fe1\u8f6c\u8d26\u5355\u53f7: " + result.getTransferBillNo());
            System.out.println("\u72b6\u6001: " + result.getState());
            System.out.println("\u8f6c\u8d26\u91d1\u989d: " + result.getTransferAmount() + "\u5206");
            System.out.println("\u7528\u6237openid: " + result.getOpenid());
            System.out.println("\u8f6c\u8d26\u5907\u6ce8: " + result.getTransferRemark());
        }
        catch (WxPayException e) {
            System.err.println("\u67e5\u8be2\u5931\u8d25: " + e.getMessage());
        }
    }

    public void queryByTransferBillNoExample() {
        try {
            String transferBillNo = "1000000000000000000000000001";
            TransferBillsGetResult result = this.transferService.getBillsByTransferBillNo(transferBillNo);
            System.out.println("=== \u67e5\u8be2\u8f6c\u8d26\u7ed3\u679c\uff08\u5fae\u4fe1\u5355\u53f7\uff09===");
            System.out.println("\u5fae\u4fe1\u8f6c\u8d26\u5355\u53f7: " + result.getTransferBillNo());
            System.out.println("\u72b6\u6001: " + result.getState());
            System.out.println("\u5931\u8d25\u539f\u56e0: " + result.getFailReason());
        }
        catch (WxPayException e) {
            System.err.println("\u67e5\u8be2\u5931\u8d25: " + e.getMessage());
        }
    }

    public void cancelTransferExample() {
        try {
            String outBillNo = "TRANSFER_1642567890123";
            TransferBillsCancelResult result = this.transferService.transformBillsCancel(outBillNo);
            System.out.println("=== \u64a4\u9500\u8f6c\u8d26\u7ed3\u679c ===");
            System.out.println("\u5546\u6237\u5355\u53f7: " + result.getOutBillNo());
            System.out.println("\u72b6\u6001: " + result.getState());
            System.out.println("\u66f4\u65b0\u65f6\u95f4: " + result.getUpdateTime());
        }
        catch (WxPayException e) {
            System.err.println("\u64a4\u9500\u5931\u8d25: " + e.getMessage());
        }
    }

    public void handleNotifyExample(String notifyData, String timestamp, String nonce, String signature, String serial) {
        try {
            SignatureHeader header = new SignatureHeader();
            header.setTimeStamp(timestamp);
            header.setNonce(nonce);
            header.setSignature(signature);
            header.setSerial(serial);
            TransferBillsNotifyResult notifyResult = this.transferService.parseTransferBillsNotifyResult(notifyData, header);
            System.out.println("=== \u5904\u7406\u8f6c\u8d26\u56de\u8c03\u901a\u77e5 ===");
            System.out.println("\u5546\u6237\u5355\u53f7: " + notifyResult.getResult().getOutBillNo());
            System.out.println("\u5fae\u4fe1\u8f6c\u8d26\u5355\u53f7: " + notifyResult.getResult().getTransferBillNo());
            System.out.println("\u72b6\u6001: " + notifyResult.getResult().getState());
            System.out.println("\u8f6c\u8d26\u91d1\u989d: " + notifyResult.getResult().getTransferAmount() + "\u5206");
            System.out.println("\u66f4\u65b0\u65f6\u95f4: " + notifyResult.getResult().getUpdateTime());
            switch (notifyResult.getResult().getState()) {
                case "SUCCESS": {
                    System.out.println("\u8f6c\u8d26\u6210\u529f\uff0c\u8fdb\u884c\u4e1a\u52a1\u5904\u7406...");
                    break;
                }
                case "FAIL": {
                    System.out.println("\u8f6c\u8d26\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0: " + notifyResult.getResult().getFailReason());
                    break;
                }
                default: {
                    System.out.println("\u5176\u4ed6\u72b6\u6001: " + notifyResult.getResult().getState());
                    break;
                }
            }
        }
        catch (WxPayException e) {
            System.err.println("\u56de\u8c03\u5904\u7406\u5931\u8d25: " + e.getMessage());
        }
    }

    public void batchTransferExample() {
        try {
            TransferBatchesRequest.TransferDetail detail1 = TransferBatchesRequest.TransferDetail.newBuilder().outDetailNo("DETAIL_" + System.currentTimeMillis() + "_1").transferAmount(100).transferRemark("\u4f63\u91d11").openid("oUpF8uMuAJO_M2pxb1Q9zNjWeS6o").userName("\u5f20\u4e09").build();
            TransferBatchesRequest.TransferDetail detail2 = TransferBatchesRequest.TransferDetail.newBuilder().outDetailNo("DETAIL_" + System.currentTimeMillis() + "_2").transferAmount(200).transferRemark("\u4f63\u91d12").openid("oUpF8uMuAJO_M2pxb1Q9zNjWeS6p").userName("\u674e\u56db").build();
            TransferBatchesRequest batchRequest = TransferBatchesRequest.newBuilder().appid("wx1234567890123456").outBatchNo("BATCH_" + System.currentTimeMillis()).batchName("\u4f63\u91d1\u6279\u91cf\u53d1\u653e").batchRemark("2024\u5e741\u6708\u4f63\u91d1").totalAmount(300).totalNum(2).transferDetailList(Arrays.asList(detail1, detail2)).transferSceneId("1005").build();
            TransferBatchesResult batchResult = this.transferService.transferBatches(batchRequest);
            System.out.println("=== \u6279\u91cf\u8f6c\u8d26\u53d1\u8d77\u6210\u529f ===");
            System.out.println("\u5546\u6237\u6279\u6b21\u5355\u53f7: " + batchResult.getOutBatchNo());
            System.out.println("\u5fae\u4fe1\u6279\u6b21\u5355\u53f7: " + batchResult.getBatchId());
            System.out.println("\u6279\u6b21\u72b6\u6001: " + batchResult.getBatchStatus());
        }
        catch (WxPayException e) {
            System.err.println("\u6279\u91cf\u8f6c\u8d26\u5931\u8d25: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        WxPayConfig config = new WxPayConfig();
        config.setAppId("wx1234567890123456");
        config.setMchId("1234567890");
        config.setApiV3Key("your_api_v3_key_32_chars");
        config.setPrivateKeyPath("path/to/private.pem");
        config.setCertSerialNo("your_certificate_serial");
        NewTransferApiExample example = new NewTransferApiExample(config);
        System.out.println("\u65b0\u7248\u5546\u6237\u8f6c\u8d26API\u4f7f\u7528\u793a\u4f8b");
        System.out.println("===============================");
        example.transferExample();
    }
}

