/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDescriptor;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public class ExifSubIFDDirectory
extends ExifDirectoryBase {
    public static final int TAG_INTEROP_OFFSET = 40965;
    @NotNull
    private static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public ExifSubIFDDirectory() {
        this.setDescriptor(new ExifSubIFDDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Exif SubIFD";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    @Nullable
    public Date getDateModified() {
        return this.getDateModified(null);
    }

    @Nullable
    public Date getDateModified(@Nullable TimeZone timeZone) {
        Directory parent = this.getParent();
        if (parent instanceof ExifIFD0Directory) {
            TimeZone timeZoneModified = this.getTimeZone(36880);
            return parent.getDate(306, this.getString(37520), timeZoneModified != null ? timeZoneModified : timeZone);
        }
        return null;
    }

    @Nullable
    public Date getDateOriginal() {
        return this.getDateOriginal(null);
    }

    @Nullable
    public Date getDateOriginal(@Nullable TimeZone timeZone) {
        TimeZone timeZoneOriginal = this.getTimeZone(36881);
        return this.getDate(36867, this.getString(37521), timeZoneOriginal != null ? timeZoneOriginal : timeZone);
    }

    @Nullable
    public Date getDateDigitized() {
        return this.getDateDigitized(null);
    }

    @Nullable
    public Date getDateDigitized(@Nullable TimeZone timeZone) {
        TimeZone timeZoneDigitized = this.getTimeZone(36882);
        return this.getDate(36868, this.getString(37522), timeZoneDigitized != null ? timeZoneDigitized : timeZone);
    }

    @Nullable
    private TimeZone getTimeZone(int tagType) {
        String timeOffset = this.getString(tagType);
        if (timeOffset != null && timeOffset.matches("[\\+\\-]\\d\\d:\\d\\d")) {
            return TimeZone.getTimeZone("GMT" + timeOffset);
        }
        return null;
    }

    static {
        ExifSubIFDDirectory.addExifTagNames(_tagNameMap);
    }
}

