/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.doris.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSampling;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.doris.ast.DorisExprTableSource;
import com.alibaba.druid.sql.dialect.doris.parser.DorisExprParser;
import com.alibaba.druid.sql.dialect.starrocks.parser.StarRocksSelectParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.Token;

public class DorisSelectParser
extends StarRocksSelectParser {
    public DorisSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
        this.dbType = DbType.doris;
    }

    @Override
    protected DorisExprParser createExprParser() {
        return new DorisExprParser(this.lexer);
    }

    @Override
    protected void parseBeforeSelectList(SQLSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.DISTINCT) {
            queryBlock.setDistionOption(2);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.DISTINCTROW) {
            queryBlock.setDistionOption(4);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.ALL) {
            this.lexer.nextToken();
            if (this.lexer.nextIf(Token.EXCEPT)) {
                queryBlock.setDistionOption(5);
            } else {
                queryBlock.setDistionOption(1);
            }
        }
    }

    @Override
    public void parseAfterTableSourceRest(SQLTableSource tableSource) {
        if (tableSource instanceof DorisExprTableSource) {
            DorisExprTableSource dorisExprTableSource = (DorisExprTableSource)tableSource;
            if (this.lexer.nextIf(Token.PARTITION)) {
                this.accept(Token.LPAREN);
                do {
                    dorisExprTableSource.addPartition(this.exprParser.name());
                } while (this.lexer.nextIf(Token.COMMA));
                this.accept(Token.RPAREN);
            }
            if (this.lexer.nextIf(Token.TABLET)) {
                this.accept(Token.LPAREN);
                dorisExprTableSource.addTablet(this.expr());
                this.accept(Token.RPAREN);
            }
            if (this.lexer.nextIf(Token.TABLESAMPLE)) {
                this.accept(Token.LPAREN);
                SQLTableSampling sqlTableSampling = new SQLTableSampling();
                SQLExpr expr = this.expr();
                if (this.lexer.nextIf(Token.ROWS)) {
                    sqlTableSampling.setRows(expr);
                } else if (this.lexer.nextIf(Token.PERCENT)) {
                    sqlTableSampling.setPercent(expr);
                } else {
                    sqlTableSampling.setByteLength(expr);
                }
                dorisExprTableSource.setSampling(sqlTableSampling);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.nextIf(Token.REPEATABLE)) {
                dorisExprTableSource.setRepeatable(this.expr());
            }
        }
    }

    @Override
    protected SQLExprTableSource getTableSource() {
        return new DorisExprTableSource();
    }
}

