/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.multimodal;

import com.alibaba.dashscope.base.FullDuplexServiceParam;
import com.alibaba.dashscope.multimodal.MultiModalDialogApiKeyWords;
import io.reactivex.Flowable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiModalRequestParam
extends FullDuplexServiceParam {
    private UpStream upStream;
    private DownStream downStream;
    private DialogAttributes dialogAttributes;
    private ClientInfo clientInfo;
    private BizParams bizParams;
    private CustomInput customInput;
    private List<Object> images;

    @Override
    public Map<String, Object> getInputs() {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        if (this.customInput != null) {
            inputs.put(MultiModalDialogApiKeyWords.CONST_NAME_TEXT, this.customInput.text);
            inputs.put(MultiModalDialogApiKeyWords.CONST_NAME_APP_ID, this.customInput.appId);
            inputs.put(MultiModalDialogApiKeyWords.CONST_NAME_DIRECTIVE, this.customInput.directive);
            inputs.put(MultiModalDialogApiKeyWords.CONST_NAME_DIALOG_ID, this.customInput.dialogId);
            inputs.put(MultiModalDialogApiKeyWords.CONST_NAME_TYPE, this.customInput.type);
            inputs.put(MultiModalDialogApiKeyWords.CONST_NAME_WORKSPACE_ID, this.customInput.workspaceId);
        }
        return inputs;
    }

    public void clearParameters() {
        this.upStream = null;
        this.downStream = null;
        this.clientInfo = null;
        this.bizParams = null;
        this.customInput = null;
        this.images = null;
        this.dialogAttributes = null;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.upStream != null) {
            HashMap<String, String> upStreamParams = new HashMap<String, String>();
            upStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_UP_STREAM_TYPE, this.upStream.type);
            upStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_UP_STREAM_MODE, this.upStream.mode);
            upStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_UP_STREAM_AUDIO_FORMAT, this.upStream.audioFormat);
            params.put(MultiModalDialogApiKeyWords.CONST_NAME_UP_STREAM, upStreamParams);
        }
        if (this.downStream != null) {
            HashMap<String, Object> downStreamParams = new HashMap<String, Object>();
            downStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM_VOICE, this.downStream.voice);
            downStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM_SAMPLE_RATE, this.downStream.sampleRate);
            downStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM_INTERMEDIATE_TEXT, this.downStream.intermediateText);
            downStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM_DEBUG, this.downStream.debug);
            downStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM_TYPE, this.downStream.type);
            downStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM_AUDIO_FORMAT, this.downStream.audioFormat);
            downStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM_VOLUME, this.downStream.volume);
            downStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM_PITCH_RATE, this.downStream.pitchRate);
            downStreamParams.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM_SPEECH_RATE, this.downStream.speechRate);
            params.put(MultiModalDialogApiKeyWords.CONST_NAME_DOWN_STREAM, downStreamParams);
        }
        if (this.clientInfo != null) {
            HashMap<String, Object> clientInfoParams = new HashMap<String, Object>();
            clientInfoParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_USER_ID, this.clientInfo.userId);
            if (this.clientInfo.device != null) {
                HashMap<String, ClientInfo.Device> deviceParams = new HashMap<String, ClientInfo.Device>();
                deviceParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_DEVICE_UUID, this.clientInfo.device);
                clientInfoParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_DEVICE, deviceParams);
            }
            if (this.clientInfo.network != null) {
                HashMap<String, String> networkParams = new HashMap<String, String>();
                networkParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_NETWORK_IP, this.clientInfo.network.ip);
                clientInfoParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_NETWORK, networkParams);
            }
            if (this.clientInfo.location != null) {
                HashMap<String, String> locationParams = new HashMap<String, String>();
                locationParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_LOCATION_CITY_NAME, this.clientInfo.location.cityName);
                locationParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_LOCATION_LATITUDE, this.clientInfo.location.latitude);
                locationParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_LOCATION_LONGITUDE, this.clientInfo.location.longitude);
                clientInfoParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_LOCATION, locationParams);
            }
            if (this.clientInfo.status != null) {
                clientInfoParams.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO_STATUS, this.clientInfo.status);
            }
            params.put(MultiModalDialogApiKeyWords.CONST_NAME_CLIENT_INFO, clientInfoParams);
        }
        if (this.bizParams != null) {
            HashMap<String, Object> bizParamsParams = new HashMap<String, Object>();
            bizParamsParams.put(MultiModalDialogApiKeyWords.CONST_NAME_BIZ_PARAMS_USER_DEFINED_PARAMS, this.bizParams.userDefinedParams);
            bizParamsParams.put(MultiModalDialogApiKeyWords.CONST_NAME_BIZ_PARAMS_USER_DEFINED_TOKENS, this.bizParams.userDefinedTokens);
            bizParamsParams.put(MultiModalDialogApiKeyWords.CONST_NAME_BIZ_PARAMS_TOOL_PROMPTS, this.bizParams.toolPrompts);
            bizParamsParams.put(MultiModalDialogApiKeyWords.CONST_NAME_BIZ_PARAMS_USER_QUERY_PARAMS, this.bizParams.userQueryParams);
            bizParamsParams.put(MultiModalDialogApiKeyWords.CONST_NAME_BIZ_PARAMS_USER_PROMPT_PARAMS, this.bizParams.userPromptParams);
            bizParamsParams.put(MultiModalDialogApiKeyWords.CONST_NAME_BIZ_PARAMS_VIDEOS, this.bizParams.videos);
            params.put(MultiModalDialogApiKeyWords.CONST_NAME_BIZ_PARAMS, bizParamsParams);
        }
        if (this.images != null) {
            params.put(MultiModalDialogApiKeyWords.CONST_NAME_IMAGES, this.images);
        }
        return params;
    }

    @Override
    public Flowable<Object> getStreamingData() {
        return null;
    }

    protected MultiModalRequestParam(MultiModalRequestParamBuilder<?, ?> b) {
        super((FullDuplexServiceParam.FullDuplexServiceParamBuilder<?, ?>)b);
        this.upStream = ((MultiModalRequestParamBuilder)b).upStream;
        this.downStream = ((MultiModalRequestParamBuilder)b).downStream;
        this.dialogAttributes = ((MultiModalRequestParamBuilder)b).dialogAttributes;
        this.clientInfo = ((MultiModalRequestParamBuilder)b).clientInfo;
        this.bizParams = ((MultiModalRequestParamBuilder)b).bizParams;
        this.customInput = ((MultiModalRequestParamBuilder)b).customInput;
        this.images = ((MultiModalRequestParamBuilder)b).images;
    }

    public static MultiModalRequestParamBuilder<?, ?> builder() {
        return new MultiModalRequestParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiModalRequestParam)) {
            return false;
        }
        MultiModalRequestParam other = (MultiModalRequestParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpStream this$upStream = this.getUpStream();
        UpStream other$upStream = other.getUpStream();
        if (this$upStream == null ? other$upStream != null : !this$upStream.equals(other$upStream)) {
            return false;
        }
        DownStream this$downStream = this.getDownStream();
        DownStream other$downStream = other.getDownStream();
        if (this$downStream == null ? other$downStream != null : !this$downStream.equals(other$downStream)) {
            return false;
        }
        DialogAttributes this$dialogAttributes = this.getDialogAttributes();
        DialogAttributes other$dialogAttributes = other.getDialogAttributes();
        if (this$dialogAttributes == null ? other$dialogAttributes != null : !this$dialogAttributes.equals(other$dialogAttributes)) {
            return false;
        }
        ClientInfo this$clientInfo = this.getClientInfo();
        ClientInfo other$clientInfo = other.getClientInfo();
        if (this$clientInfo == null ? other$clientInfo != null : !this$clientInfo.equals(other$clientInfo)) {
            return false;
        }
        BizParams this$bizParams = this.getBizParams();
        BizParams other$bizParams = other.getBizParams();
        if (this$bizParams == null ? other$bizParams != null : !this$bizParams.equals(other$bizParams)) {
            return false;
        }
        CustomInput this$customInput = this.getCustomInput();
        CustomInput other$customInput = other.getCustomInput();
        if (this$customInput == null ? other$customInput != null : !this$customInput.equals(other$customInput)) {
            return false;
        }
        List<Object> this$images = this.getImages();
        List<Object> other$images = other.getImages();
        return !(this$images == null ? other$images != null : !((Object)this$images).equals(other$images));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiModalRequestParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UpStream $upStream = this.getUpStream();
        result = result * 59 + ($upStream == null ? 43 : $upStream.hashCode());
        DownStream $downStream = this.getDownStream();
        result = result * 59 + ($downStream == null ? 43 : $downStream.hashCode());
        DialogAttributes $dialogAttributes = this.getDialogAttributes();
        result = result * 59 + ($dialogAttributes == null ? 43 : $dialogAttributes.hashCode());
        ClientInfo $clientInfo = this.getClientInfo();
        result = result * 59 + ($clientInfo == null ? 43 : $clientInfo.hashCode());
        BizParams $bizParams = this.getBizParams();
        result = result * 59 + ($bizParams == null ? 43 : $bizParams.hashCode());
        CustomInput $customInput = this.getCustomInput();
        result = result * 59 + ($customInput == null ? 43 : $customInput.hashCode());
        List<Object> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        return result;
    }

    public UpStream getUpStream() {
        return this.upStream;
    }

    public DownStream getDownStream() {
        return this.downStream;
    }

    public DialogAttributes getDialogAttributes() {
        return this.dialogAttributes;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public BizParams getBizParams() {
        return this.bizParams;
    }

    public CustomInput getCustomInput() {
        return this.customInput;
    }

    public List<Object> getImages() {
        return this.images;
    }

    public void setUpStream(UpStream upStream) {
        this.upStream = upStream;
    }

    public void setDownStream(DownStream downStream) {
        this.downStream = downStream;
    }

    public void setDialogAttributes(DialogAttributes dialogAttributes) {
        this.dialogAttributes = dialogAttributes;
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public void setBizParams(BizParams bizParams) {
        this.bizParams = bizParams;
    }

    public void setCustomInput(CustomInput customInput) {
        this.customInput = customInput;
    }

    public void setImages(List<Object> images) {
        this.images = images;
    }

    @Override
    public String toString() {
        return "MultiModalRequestParam(upStream=" + this.getUpStream() + ", downStream=" + this.getDownStream() + ", dialogAttributes=" + this.getDialogAttributes() + ", clientInfo=" + this.getClientInfo() + ", bizParams=" + this.getBizParams() + ", customInput=" + this.getCustomInput() + ", images=" + this.getImages() + ")";
    }

    private static final class MultiModalRequestParamBuilderImpl
    extends MultiModalRequestParamBuilder<MultiModalRequestParam, MultiModalRequestParamBuilderImpl> {
        private MultiModalRequestParamBuilderImpl() {
        }

        @Override
        protected MultiModalRequestParamBuilderImpl self() {
            return this;
        }

        @Override
        public MultiModalRequestParam build() {
            return new MultiModalRequestParam(this);
        }
    }

    public static abstract class MultiModalRequestParamBuilder<C extends MultiModalRequestParam, B extends MultiModalRequestParamBuilder<C, B>>
    extends FullDuplexServiceParam.FullDuplexServiceParamBuilder<C, B> {
        private UpStream upStream;
        private DownStream downStream;
        private DialogAttributes dialogAttributes;
        private ClientInfo clientInfo;
        private BizParams bizParams;
        private CustomInput customInput;
        private List<Object> images;

        public B upStream(UpStream upStream) {
            this.upStream = upStream;
            return (B)this.self();
        }

        public B downStream(DownStream downStream) {
            this.downStream = downStream;
            return (B)this.self();
        }

        public B dialogAttributes(DialogAttributes dialogAttributes) {
            this.dialogAttributes = dialogAttributes;
            return (B)this.self();
        }

        public B clientInfo(ClientInfo clientInfo) {
            this.clientInfo = clientInfo;
            return (B)this.self();
        }

        public B bizParams(BizParams bizParams) {
            this.bizParams = bizParams;
            return (B)this.self();
        }

        public B customInput(CustomInput customInput) {
            this.customInput = customInput;
            return (B)this.self();
        }

        public B images(List<Object> images) {
            this.images = images;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "MultiModalRequestParam.MultiModalRequestParamBuilder(super=" + super.toString() + ", upStream=" + this.upStream + ", downStream=" + this.downStream + ", dialogAttributes=" + this.dialogAttributes + ", clientInfo=" + this.clientInfo + ", bizParams=" + this.bizParams + ", customInput=" + this.customInput + ", images=" + this.images + ")";
        }
    }

    public static class UpdateParams {
        List<Object> images;
        BizParams bizParams;
        ClientInfo clientInfo;

        UpdateParams(List<Object> images, BizParams bizParams, ClientInfo clientInfo) {
            this.images = images;
            this.bizParams = bizParams;
            this.clientInfo = clientInfo;
        }

        public static UpdateParamsBuilder builder() {
            return new UpdateParamsBuilder();
        }

        public static class UpdateParamsBuilder {
            private List<Object> images;
            private BizParams bizParams;
            private ClientInfo clientInfo;

            UpdateParamsBuilder() {
            }

            public UpdateParamsBuilder images(List<Object> images) {
                this.images = images;
                return this;
            }

            public UpdateParamsBuilder bizParams(BizParams bizParams) {
                this.bizParams = bizParams;
                return this;
            }

            public UpdateParamsBuilder clientInfo(ClientInfo clientInfo) {
                this.clientInfo = clientInfo;
                return this;
            }

            public UpdateParams build() {
                return new UpdateParams(this.images, this.bizParams, this.clientInfo);
            }

            public String toString() {
                return "MultiModalRequestParam.UpdateParams.UpdateParamsBuilder(images=" + this.images + ", bizParams=" + this.bizParams + ", clientInfo=" + this.clientInfo + ")";
            }
        }
    }

    public static class BizParams {
        private Object userDefinedParams;
        private Object userDefinedTokens;
        private Object toolPrompts;
        private Object userQueryParams;
        private Object userPromptParams;
        private Object videos;

        BizParams(Object userDefinedParams, Object userDefinedTokens, Object toolPrompts, Object userQueryParams, Object userPromptParams, Object videos) {
            this.userDefinedParams = userDefinedParams;
            this.userDefinedTokens = userDefinedTokens;
            this.toolPrompts = toolPrompts;
            this.userQueryParams = userQueryParams;
            this.userPromptParams = userPromptParams;
            this.videos = videos;
        }

        public static BizParamsBuilder builder() {
            return new BizParamsBuilder();
        }

        public static class BizParamsBuilder {
            private Object userDefinedParams;
            private Object userDefinedTokens;
            private Object toolPrompts;
            private Object userQueryParams;
            private Object userPromptParams;
            private Object videos;

            BizParamsBuilder() {
            }

            public BizParamsBuilder userDefinedParams(Object userDefinedParams) {
                this.userDefinedParams = userDefinedParams;
                return this;
            }

            public BizParamsBuilder userDefinedTokens(Object userDefinedTokens) {
                this.userDefinedTokens = userDefinedTokens;
                return this;
            }

            public BizParamsBuilder toolPrompts(Object toolPrompts) {
                this.toolPrompts = toolPrompts;
                return this;
            }

            public BizParamsBuilder userQueryParams(Object userQueryParams) {
                this.userQueryParams = userQueryParams;
                return this;
            }

            public BizParamsBuilder userPromptParams(Object userPromptParams) {
                this.userPromptParams = userPromptParams;
                return this;
            }

            public BizParamsBuilder videos(Object videos) {
                this.videos = videos;
                return this;
            }

            public BizParams build() {
                return new BizParams(this.userDefinedParams, this.userDefinedTokens, this.toolPrompts, this.userQueryParams, this.userPromptParams, this.videos);
            }

            public String toString() {
                return "MultiModalRequestParam.BizParams.BizParamsBuilder(userDefinedParams=" + this.userDefinedParams + ", userDefinedTokens=" + this.userDefinedTokens + ", toolPrompts=" + this.toolPrompts + ", userQueryParams=" + this.userQueryParams + ", userPromptParams=" + this.userPromptParams + ", videos=" + this.videos + ")";
            }
        }
    }

    public static class ClientInfo {
        private String userId;
        private Device device;
        private Network network;
        private Locations location;
        private Object status;

        ClientInfo(String userId, Device device, Network network, Locations location, Object status) {
            this.userId = userId;
            this.device = device;
            this.network = network;
            this.location = location;
            this.status = status;
        }

        public static ClientInfoBuilder builder() {
            return new ClientInfoBuilder();
        }

        public static class ClientInfoBuilder {
            private String userId;
            private Device device;
            private Network network;
            private Locations location;
            private Object status;

            ClientInfoBuilder() {
            }

            public ClientInfoBuilder userId(String userId) {
                this.userId = userId;
                return this;
            }

            public ClientInfoBuilder device(Device device) {
                this.device = device;
                return this;
            }

            public ClientInfoBuilder network(Network network) {
                this.network = network;
                return this;
            }

            public ClientInfoBuilder location(Locations location) {
                this.location = location;
                return this;
            }

            public ClientInfoBuilder status(Object status) {
                this.status = status;
                return this;
            }

            public ClientInfo build() {
                return new ClientInfo(this.userId, this.device, this.network, this.location, this.status);
            }

            public String toString() {
                return "MultiModalRequestParam.ClientInfo.ClientInfoBuilder(userId=" + this.userId + ", device=" + this.device + ", network=" + this.network + ", location=" + this.location + ", status=" + this.status + ")";
            }
        }

        public static class Locations {
            private String cityName;
            private String latitude;
            private String longitude;

            Locations(String cityName, String latitude, String longitude) {
                this.cityName = cityName;
                this.latitude = latitude;
                this.longitude = longitude;
            }

            public static LocationsBuilder builder() {
                return new LocationsBuilder();
            }

            public static class LocationsBuilder {
                private String cityName;
                private String latitude;
                private String longitude;

                LocationsBuilder() {
                }

                public LocationsBuilder cityName(String cityName) {
                    this.cityName = cityName;
                    return this;
                }

                public LocationsBuilder latitude(String latitude) {
                    this.latitude = latitude;
                    return this;
                }

                public LocationsBuilder longitude(String longitude) {
                    this.longitude = longitude;
                    return this;
                }

                public Locations build() {
                    return new Locations(this.cityName, this.latitude, this.longitude);
                }

                public String toString() {
                    return "MultiModalRequestParam.ClientInfo.Locations.LocationsBuilder(cityName=" + this.cityName + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ")";
                }
            }
        }

        public static class Device {
            private String uuid;

            Device(String uuid) {
                this.uuid = uuid;
            }

            public static DeviceBuilder builder() {
                return new DeviceBuilder();
            }

            public static class DeviceBuilder {
                private String uuid;

                DeviceBuilder() {
                }

                public DeviceBuilder uuid(String uuid) {
                    this.uuid = uuid;
                    return this;
                }

                public Device build() {
                    return new Device(this.uuid);
                }

                public String toString() {
                    return "MultiModalRequestParam.ClientInfo.Device.DeviceBuilder(uuid=" + this.uuid + ")";
                }
            }
        }

        public static class Network {
            private String ip;

            Network(String ip) {
                this.ip = ip;
            }

            public static NetworkBuilder builder() {
                return new NetworkBuilder();
            }

            public static class NetworkBuilder {
                private String ip;

                NetworkBuilder() {
                }

                public NetworkBuilder ip(String ip) {
                    this.ip = ip;
                    return this;
                }

                public Network build() {
                    return new Network(this.ip);
                }

                public String toString() {
                    return "MultiModalRequestParam.ClientInfo.Network.NetworkBuilder(ip=" + this.ip + ")";
                }
            }
        }
    }

    public static class DialogAttributes {
        DialogAttributes() {
        }

        public static DialogAttributesBuilder builder() {
            return new DialogAttributesBuilder();
        }

        public static class DialogAttributesBuilder {
            DialogAttributesBuilder() {
            }

            public DialogAttributes build() {
                return new DialogAttributes();
            }

            public String toString() {
                return "MultiModalRequestParam.DialogAttributes.DialogAttributesBuilder()";
            }
        }
    }

    public static class DownStream {
        private String voice;
        private int sampleRate;
        private String intermediateText;
        private boolean debug;
        private String type;
        private int volume;
        private int pitchRate;
        private int speechRate;
        private String audioFormat;

        private static String $default$intermediateText() {
            return "transcript";
        }

        private static boolean $default$debug() {
            return false;
        }

        private static String $default$type() {
            return "Audio";
        }

        private static int $default$volume() {
            return 50;
        }

        private static int $default$pitchRate() {
            return 100;
        }

        private static int $default$speechRate() {
            return 100;
        }

        private static String $default$audioFormat() {
            return "pcm";
        }

        DownStream(String voice, int sampleRate, String intermediateText, boolean debug, String type, int volume, int pitchRate, int speechRate, String audioFormat) {
            this.voice = voice;
            this.sampleRate = sampleRate;
            this.intermediateText = intermediateText;
            this.debug = debug;
            this.type = type;
            this.volume = volume;
            this.pitchRate = pitchRate;
            this.speechRate = speechRate;
            this.audioFormat = audioFormat;
        }

        public static DownStreamBuilder builder() {
            return new DownStreamBuilder();
        }

        public static class DownStreamBuilder {
            private String voice;
            private int sampleRate;
            private boolean intermediateText$set;
            private String intermediateText$value;
            private boolean debug$set;
            private boolean debug$value;
            private boolean type$set;
            private String type$value;
            private boolean volume$set;
            private int volume$value;
            private boolean pitchRate$set;
            private int pitchRate$value;
            private boolean speechRate$set;
            private int speechRate$value;
            private boolean audioFormat$set;
            private String audioFormat$value;

            DownStreamBuilder() {
            }

            public DownStreamBuilder voice(String voice) {
                this.voice = voice;
                return this;
            }

            public DownStreamBuilder sampleRate(int sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            public DownStreamBuilder intermediateText(String intermediateText) {
                this.intermediateText$value = intermediateText;
                this.intermediateText$set = true;
                return this;
            }

            public DownStreamBuilder debug(boolean debug) {
                this.debug$value = debug;
                this.debug$set = true;
                return this;
            }

            public DownStreamBuilder type(String type) {
                this.type$value = type;
                this.type$set = true;
                return this;
            }

            public DownStreamBuilder volume(int volume) {
                this.volume$value = volume;
                this.volume$set = true;
                return this;
            }

            public DownStreamBuilder pitchRate(int pitchRate) {
                this.pitchRate$value = pitchRate;
                this.pitchRate$set = true;
                return this;
            }

            public DownStreamBuilder speechRate(int speechRate) {
                this.speechRate$value = speechRate;
                this.speechRate$set = true;
                return this;
            }

            public DownStreamBuilder audioFormat(String audioFormat) {
                this.audioFormat$value = audioFormat;
                this.audioFormat$set = true;
                return this;
            }

            public DownStream build() {
                String intermediateText$value = this.intermediateText$value;
                if (!this.intermediateText$set) {
                    intermediateText$value = DownStream.$default$intermediateText();
                }
                boolean debug$value = this.debug$value;
                if (!this.debug$set) {
                    debug$value = DownStream.$default$debug();
                }
                String type$value = this.type$value;
                if (!this.type$set) {
                    type$value = DownStream.$default$type();
                }
                int volume$value = this.volume$value;
                if (!this.volume$set) {
                    volume$value = DownStream.$default$volume();
                }
                int pitchRate$value = this.pitchRate$value;
                if (!this.pitchRate$set) {
                    pitchRate$value = DownStream.$default$pitchRate();
                }
                int speechRate$value = this.speechRate$value;
                if (!this.speechRate$set) {
                    speechRate$value = DownStream.$default$speechRate();
                }
                String audioFormat$value = this.audioFormat$value;
                if (!this.audioFormat$set) {
                    audioFormat$value = DownStream.$default$audioFormat();
                }
                return new DownStream(this.voice, this.sampleRate, intermediateText$value, debug$value, type$value, volume$value, pitchRate$value, speechRate$value, audioFormat$value);
            }

            public String toString() {
                return "MultiModalRequestParam.DownStream.DownStreamBuilder(voice=" + this.voice + ", sampleRate=" + this.sampleRate + ", intermediateText$value=" + this.intermediateText$value + ", debug$value=" + this.debug$value + ", type$value=" + this.type$value + ", volume$value=" + this.volume$value + ", pitchRate$value=" + this.pitchRate$value + ", speechRate$value=" + this.speechRate$value + ", audioFormat$value=" + this.audioFormat$value + ")";
            }
        }
    }

    public static class UpStream {
        private String type = "AudioOnly";
        private String mode;
        private String audioFormat;

        private static String $default$audioFormat() {
            return MultiModalDialogApiKeyWords.CONST_AUDIO_FORMAT_PCM;
        }

        UpStream(String type, String mode, String audioFormat) {
            this.type = type;
            this.mode = mode;
            this.audioFormat = audioFormat;
        }

        public static UpStreamBuilder builder() {
            return new UpStreamBuilder();
        }

        public static class UpStreamBuilder {
            private String type;
            private String mode;
            private boolean audioFormat$set;
            private String audioFormat$value;

            UpStreamBuilder() {
            }

            public UpStreamBuilder type(String type) {
                this.type = type;
                return this;
            }

            public UpStreamBuilder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public UpStreamBuilder audioFormat(String audioFormat) {
                this.audioFormat$value = audioFormat;
                this.audioFormat$set = true;
                return this;
            }

            public UpStream build() {
                String audioFormat$value = this.audioFormat$value;
                if (!this.audioFormat$set) {
                    audioFormat$value = UpStream.$default$audioFormat();
                }
                return new UpStream(this.type, this.mode, audioFormat$value);
            }

            public String toString() {
                return "MultiModalRequestParam.UpStream.UpStreamBuilder(type=" + this.type + ", mode=" + this.mode + ", audioFormat$value=" + this.audioFormat$value + ")";
            }
        }
    }

    public static class CustomInput {
        private String workspaceId;
        private String appId;
        private String directive;
        private String dialogId;
        private String text;
        private String type;

        private static String $default$directive() {
            return "Start";
        }

        private static String $default$text() {
            return null;
        }

        private static String $default$type() {
            return null;
        }

        CustomInput(String workspaceId, String appId, String directive, String dialogId, String text, String type) {
            this.workspaceId = workspaceId;
            this.appId = appId;
            this.directive = directive;
            this.dialogId = dialogId;
            this.text = text;
            this.type = type;
        }

        public static CustomInputBuilder builder() {
            return new CustomInputBuilder();
        }

        public static class CustomInputBuilder {
            private String workspaceId;
            private String appId;
            private boolean directive$set;
            private String directive$value;
            private String dialogId;
            private boolean text$set;
            private String text$value;
            private boolean type$set;
            private String type$value;

            CustomInputBuilder() {
            }

            public CustomInputBuilder workspaceId(String workspaceId) {
                this.workspaceId = workspaceId;
                return this;
            }

            public CustomInputBuilder appId(String appId) {
                this.appId = appId;
                return this;
            }

            public CustomInputBuilder directive(String directive) {
                this.directive$value = directive;
                this.directive$set = true;
                return this;
            }

            public CustomInputBuilder dialogId(String dialogId) {
                this.dialogId = dialogId;
                return this;
            }

            public CustomInputBuilder text(String text) {
                this.text$value = text;
                this.text$set = true;
                return this;
            }

            public CustomInputBuilder type(String type) {
                this.type$value = type;
                this.type$set = true;
                return this;
            }

            public CustomInput build() {
                String directive$value = this.directive$value;
                if (!this.directive$set) {
                    directive$value = CustomInput.$default$directive();
                }
                String text$value = this.text$value;
                if (!this.text$set) {
                    text$value = CustomInput.$default$text();
                }
                String type$value = this.type$value;
                if (!this.type$set) {
                    type$value = CustomInput.$default$type();
                }
                return new CustomInput(this.workspaceId, this.appId, directive$value, this.dialogId, text$value, type$value);
            }

            public String toString() {
                return "MultiModalRequestParam.CustomInput.CustomInputBuilder(workspaceId=" + this.workspaceId + ", appId=" + this.appId + ", directive$value=" + this.directive$value + ", dialogId=" + this.dialogId + ", text$value=" + this.text$value + ", type$value=" + this.type$value + ")";
            }
        }
    }
}

