/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.store;

import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.store.VectorData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class VectorStore<T extends VectorData> {
    public StoreResult store(T vectorData) {
        return this.store(vectorData, StoreOptions.DEFAULT);
    }

    public StoreResult store(T vectorData, StoreOptions options) {
        return this.store(Collections.singletonList(vectorData), options);
    }

    public StoreResult store(List<T> vectorDataList) {
        return this.store(vectorDataList, StoreOptions.DEFAULT);
    }

    public abstract StoreResult store(List<T> var1, StoreOptions var2);

    public StoreResult delete(String ... ids) {
        return this.delete(Arrays.asList(ids), StoreOptions.DEFAULT);
    }

    public StoreResult delete(Number ... ids) {
        return this.delete(Arrays.asList(ids), StoreOptions.DEFAULT);
    }

    public StoreResult delete(Collection<?> ids) {
        return this.delete(ids, StoreOptions.DEFAULT);
    }

    public abstract StoreResult delete(Collection<?> var1, StoreOptions var2);

    public StoreResult update(T vectorData) {
        return this.update(vectorData, StoreOptions.DEFAULT);
    }

    public StoreResult update(T vectorData, StoreOptions options) {
        return this.update(Collections.singletonList(vectorData), options);
    }

    public StoreResult update(List<T> vectorDataList) {
        return this.update(vectorDataList, StoreOptions.DEFAULT);
    }

    public abstract StoreResult update(List<T> var1, StoreOptions var2);

    public List<T> search(SearchWrapper wrapper) {
        return this.search(wrapper, StoreOptions.DEFAULT);
    }

    public abstract List<T> search(SearchWrapper var1, StoreOptions var2);
}

