/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.client.impl;

import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.OkHttpClientUtil;
import com.agentsflex.core.llm.client.impl.Util;
import com.agentsflex.core.util.LogUtil;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SseClient
extends EventSourceListener
implements LlmClient {
    private OkHttpClient okHttpClient;
    private EventSource eventSource;
    private LlmClientListener listener;
    private LlmConfig config;
    private boolean isStop = false;

    @Override
    public void start(String url, Map<String, String> headers, String payload, LlmClientListener listener, LlmConfig config) {
        this.listener = listener;
        this.config = config;
        this.isStop = false;
        Request.Builder builder = new Request.Builder().url(url);
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((String)payload, (MediaType)mediaType);
        Request request = builder.post(body).build();
        this.okHttpClient = OkHttpClientUtil.buildDefaultClient();
        EventSource.Factory factory = EventSources.createFactory((OkHttpClient)this.okHttpClient);
        this.eventSource = factory.newEventSource(request, (EventSourceListener)this);
        if (this.config.isDebug()) {
            LogUtil.println(">>>>send payload:" + payload);
        }
        this.listener.onStart(this);
    }

    @Override
    public void stop() {
        this.tryToStop();
    }

    public void onClosed(@NotNull EventSource eventSource) {
        this.tryToStop();
    }

    public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
        if (this.config.isDebug()) {
            LogUtil.println(">>>>receive payload:" + data);
        }
        this.listener.onMessage(this, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
        try {
            this.listener.onFailure(this, Util.getFailureThrowable(t, response));
        }
        finally {
            this.tryToStop();
        }
    }

    public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
    }

    private boolean tryToStop() {
        if (!this.isStop) {
            try {
                this.isStop = true;
                this.listener.onStop(this);
            }
            finally {
                if (this.eventSource != null) {
                    this.eventSource.cancel();
                }
                if (this.okHttpClient != null) {
                    this.okHttpClient.dispatcher().executorService().shutdown();
                }
            }
            return true;
        }
        return false;
    }
}

