/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.eviction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.redisson.api.MapCacheOptions;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionTask;
import org.redisson.eviction.JCacheEvictionTask;
import org.redisson.eviction.MapCacheEvictionTask;
import org.redisson.eviction.MultimapEvictionTask;
import org.redisson.eviction.ScoredSetEvictionTask;
import org.redisson.eviction.TimeSeriesEvictionTask;

public final class EvictionScheduler {
    private final Map<String, EvictionTask> tasks = new ConcurrentHashMap<String, EvictionTask>();
    private final CommandAsyncExecutor executor;

    public EvictionScheduler(CommandAsyncExecutor executor) {
        this.executor = executor;
    }

    private void addTask(String name, Supplier<EvictionTask> supplier) {
        this.tasks.computeIfAbsent(name, k -> {
            EvictionTask task = (EvictionTask)supplier.get();
            task.schedule();
            return task;
        });
    }

    public void scheduleCleanMultimap(String name, String timeoutSetName) {
        this.addTask(name, () -> new MultimapEvictionTask(name, timeoutSetName, this.executor));
    }

    public void scheduleJCache(String name, String timeoutSetName, String expiredChannelName) {
        this.addTask(name, () -> new JCacheEvictionTask(name, timeoutSetName, expiredChannelName, this.executor));
    }

    public void scheduleTimeSeries(String name, String timeoutSetName) {
        this.addTask(name, () -> new TimeSeriesEvictionTask(name, timeoutSetName, this.executor));
    }

    public void schedule(String name, long shiftInMilliseconds) {
        this.addTask(name, () -> new ScoredSetEvictionTask(name, this.executor, shiftInMilliseconds));
    }

    public void schedule(String name, String timeoutSetName, String maxIdleSetName, String expiredChannelName, String lastAccessTimeSetName, MapCacheOptions<?, ?> options, String publishCommand) {
        boolean removeEmpty = options != null ? options.isRemoveEmptyEvictionTask() : false;
        this.addTask(name, () -> new MapCacheEvictionTask(name, timeoutSetName, maxIdleSetName, expiredChannelName, lastAccessTimeSetName, this.executor, removeEmpty, this, publishCommand));
    }

    public void remove(String name) {
        this.tasks.computeIfPresent(name, (k, task) -> {
            task.cancel();
            return null;
        });
    }
}

