/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.pubsub.PubSubMessage;
import org.redisson.client.protocol.pubsub.PubSubMessageDecoder;
import org.redisson.client.protocol.pubsub.PubSubPatternMessage;
import org.redisson.client.protocol.pubsub.PubSubPatternMessageDecoder;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.misc.FastRemovalQueue;

public class RedisPubSubConnection
extends RedisConnection {
    private static final FastRemovalQueue<RedisPubSubListener<Object>> EMPTY_QUEUE = new FastRemovalQueue();
    final Map<ChannelName, FastRemovalQueue<RedisPubSubListener<Object>>> listeners = new ConcurrentHashMap<ChannelName, FastRemovalQueue<RedisPubSubListener<Object>>>();
    final Map<ChannelName, Codec> channels = new ConcurrentHashMap<ChannelName, Codec>();
    final Map<ChannelName, Codec> shardedChannels = new ConcurrentHashMap<ChannelName, Codec>();
    final Map<ChannelName, Codec> patternChannels = new ConcurrentHashMap<ChannelName, Codec>();
    final Map<ChannelName, PubSubType> unsubscribedChannels = new ConcurrentHashMap<ChannelName, PubSubType>();

    public RedisPubSubConnection(RedisClient redisClient, Channel channel, CompletableFuture<RedisPubSubConnection> connectionPromise) {
        super(redisClient, channel, connectionPromise);
    }

    public void addListener(ChannelName channelName, RedisPubSubListener<?> listener) {
        FastRemovalQueue queue = this.listeners.computeIfAbsent(channelName, c -> new FastRemovalQueue());
        queue.add(listener);
    }

    public void removeListener(ChannelName channelName, RedisPubSubListener<?> listener) {
        this.listeners.compute(channelName, (k, queue) -> {
            if (queue == null) {
                return null;
            }
            queue.remove(listener);
            if (queue.isEmpty()) {
                return null;
            }
            return queue;
        });
    }

    public void onMessage(PubSubStatusMessage message) {
        FastRemovalQueue<RedisPubSubListener<Object>> queue = this.listeners.getOrDefault(message.getChannel(), EMPTY_QUEUE);
        for (RedisPubSubListener<Object> redisPubSubListener : queue) {
            redisPubSubListener.onStatus(message.getType(), message.getChannel());
        }
    }

    public void onMessage(PubSubMessage message) {
        FastRemovalQueue<RedisPubSubListener<Object>> queue = this.listeners.getOrDefault(message.getChannel(), EMPTY_QUEUE);
        for (RedisPubSubListener<Object> redisPubSubListener : queue) {
            redisPubSubListener.onMessage(message.getChannel(), message.getValue());
        }
    }

    public void onMessage(PubSubPatternMessage message) {
        FastRemovalQueue<RedisPubSubListener<Object>> queue = this.listeners.getOrDefault(message.getPattern(), EMPTY_QUEUE);
        for (RedisPubSubListener<Object> redisPubSubListener : queue) {
            redisPubSubListener.onPatternMessage(message.getPattern(), message.getChannel(), message.getValue());
        }
    }

    public ChannelFuture subscribe(CompletableFuture<Void> promise, Codec codec, ChannelName ... channels) {
        for (ChannelName ch : channels) {
            this.channels.put(ch, codec);
        }
        return this.async(promise, new PubSubMessageDecoder(codec.getValueDecoder()), RedisCommands.SUBSCRIBE, (Object[])channels);
    }

    public ChannelFuture ssubscribe(CompletableFuture<Void> promise, Codec codec, ChannelName ... channels) {
        for (ChannelName ch : channels) {
            this.shardedChannels.put(ch, codec);
        }
        return this.async(promise, new PubSubMessageDecoder(codec.getValueDecoder()), RedisCommands.SSUBSCRIBE, (Object[])channels);
    }

    public ChannelFuture psubscribe(CompletableFuture<Void> promise, Codec codec, ChannelName ... channels) {
        for (ChannelName ch : channels) {
            this.patternChannels.put(ch, codec);
        }
        return this.async(promise, new PubSubPatternMessageDecoder(codec.getValueDecoder()), RedisCommands.PSUBSCRIBE, (Object[])channels);
    }

    public ChannelFuture subscribe(Codec codec, ChannelName ... channels) {
        for (ChannelName ch : channels) {
            this.channels.put(ch, codec);
        }
        return this.async(new PubSubMessageDecoder(codec.getValueDecoder()), RedisCommands.SUBSCRIBE, (Object[])channels);
    }

    public ChannelFuture ssubscribe(Codec codec, ChannelName ... channels) {
        for (ChannelName ch : channels) {
            this.shardedChannels.put(ch, codec);
        }
        return this.async(new PubSubMessageDecoder(codec.getValueDecoder()), RedisCommands.SSUBSCRIBE, (Object[])channels);
    }

    public ChannelFuture psubscribe(Codec codec, ChannelName ... channels) {
        for (ChannelName ch : channels) {
            this.patternChannels.put(ch, codec);
        }
        return this.async(new PubSubPatternMessageDecoder(codec.getValueDecoder()), RedisCommands.PSUBSCRIBE, (Object[])channels);
    }

    public ChannelFuture unsubscribe(PubSubType type, ChannelName ... channels) {
        RedisCommand<Object> command;
        if (type == PubSubType.UNSUBSCRIBE) {
            command = RedisCommands.UNSUBSCRIBE;
            for (ChannelName ch : channels) {
                this.channels.remove(ch);
                this.unsubscribedChannels.put(ch, type);
            }
        } else if (type == PubSubType.SUNSUBSCRIBE) {
            command = RedisCommands.SUNSUBSCRIBE;
            for (ChannelName ch : channels) {
                this.shardedChannels.remove(ch);
                this.unsubscribedChannels.put(ch, type);
            }
        } else {
            command = RedisCommands.PUNSUBSCRIBE;
            for (ChannelName ch : channels) {
                this.patternChannels.remove(ch);
                this.unsubscribedChannels.put(ch, type);
            }
        }
        ChannelFuture future = this.async((MultiDecoder<Object>)null, command, (Object[])channels);
        future.addListener((GenericFutureListener)((FutureListener)f -> {
            if (!f.isSuccess()) {
                for (ChannelName channel : channels) {
                    this.removeDisconnectListener(channel);
                    this.onMessage(new PubSubStatusMessage(type, channel));
                }
            }
        }));
        return future;
    }

    public void removeDisconnectListener(ChannelName channel) {
        this.unsubscribedChannels.remove(channel);
    }

    @Override
    public void fireDisconnected() {
        super.fireDisconnected();
        this.unsubscribedChannels.forEach((key, value) -> this.onMessage(new PubSubStatusMessage((PubSubType)((Object)value), (ChannelName)key)));
    }

    private <T, R> ChannelFuture async(MultiDecoder<Object> messageDecoder, RedisCommand<T> command, Object ... params) {
        CompletableFuture promise = new CompletableFuture();
        return this.channel.writeAndFlush(new CommandData(promise, messageDecoder, null, command, params));
    }

    private <T, R> ChannelFuture async(CompletableFuture<Void> promise, MultiDecoder<Object> messageDecoder, RedisCommand<T> command, Object ... params) {
        return this.channel.writeAndFlush(new CommandData<T, Void>(promise, messageDecoder, null, command, params));
    }

    public Map<ChannelName, Codec> getShardedChannels() {
        return Collections.unmodifiableMap(this.shardedChannels);
    }

    public Map<ChannelName, Codec> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    public Map<ChannelName, Codec> getPatternChannels() {
        return Collections.unmodifiableMap(this.patternChannels);
    }
}

