/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.redisson.SlotCallback;
import org.redisson.VoidSlotCallback;
import org.redisson.api.RFuture;
import org.redisson.api.RJsonBuckets;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.JsonCodec;
import org.redisson.codec.JsonCodecWrapper;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.BucketsDecoder;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.misc.CompletableFutureWrapper;

public final class RedissonJsonBuckets
implements RJsonBuckets {
    protected final JsonCodec codec;
    protected final CommandAsyncExecutor commandExecutor;

    RedissonJsonBuckets(JsonCodec codec, CommandAsyncExecutor commandExecutor) {
        this.codec = codec;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public <V> Map<String, V> get(String ... keys) {
        RFuture<Map<String, V>> future = this.getAsync(keys);
        return this.commandExecutor.get(future);
    }

    @Override
    public <V> RFuture<Map<String, V>> getAsync(String ... keys) {
        return this.getAsync(this.codec, ".", keys);
    }

    @Override
    public <V> Map<String, V> get(JsonCodec codec, String path, String ... keys) {
        RFuture<Map<String, V>> future = this.getAsync(codec, path, keys);
        return this.commandExecutor.get(future);
    }

    @Override
    public <V> RFuture<Map<String, V>> getAsync(JsonCodec codec, final String path, String ... keys) {
        if (keys.length == 0) {
            return new CompletableFutureWrapper<Map<String, V>>(Collections.emptyMap());
        }
        List<Object> keysList = Arrays.stream(keys).map(k -> this.commandExecutor.getServiceManager().getConfig().getNameMapper().map((String)k)).collect(Collectors.toList());
        JsonCodecWrapper jsonCodec = new JsonCodecWrapper(codec);
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("JSON.MGET", new MapGetAllDecoder(keysList, 0));
        return this.commandExecutor.readBatchedAsync(jsonCodec, command, new SlotCallback<Map<Object, Object>, Map<String, V>>(){

            @Override
            public Map<String, V> onResult(Collection<Map<Object, Object>> result) {
                return result.stream().flatMap(c -> c.entrySet().stream()).filter(e -> e.getKey() != null && e.getValue() != null).map(e -> {
                    String key = RedissonJsonBuckets.this.commandExecutor.getServiceManager().getConfig().getNameMapper().unmap((String)e.getKey());
                    return new AbstractMap.SimpleEntry(key, e.getValue());
                }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
            }

            @Override
            public RedisCommand<Map<Object, Object>> createCommand(List<Object> keys) {
                return new RedisCommand<Map<Object, Object>>("JSON.MGET", new BucketsDecoder(keys));
            }

            @Override
            public Object[] createParams(List<Object> params) {
                ArrayList<Object> newParams = new ArrayList<Object>(params);
                newParams.add(path);
                return newParams.toArray();
            }
        }, keysList.toArray(new Object[0]));
    }

    @Override
    public void set(Map<String, ?> buckets) {
        this.commandExecutor.get(this.setAsync(buckets));
    }

    @Override
    public RFuture<Void> setAsync(Map<String, ?> buckets) {
        return this.setAsync(this.codec, ".", buckets);
    }

    @Override
    public void set(JsonCodec codec, String path, Map<String, ?> buckets) {
        this.commandExecutor.get(this.setAsync(codec, path, buckets));
    }

    @Override
    public RFuture<Void> setAsync(JsonCodec codec, final String path, Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        final Map<String, Object> mappedBuckets = buckets.entrySet().stream().collect(Collectors.toMap(e -> this.commandExecutor.getServiceManager().getConfig().getNameMapper().map((String)e.getKey()), Map.Entry::getValue));
        final JsonCodecWrapper jsonCodec = new JsonCodecWrapper(codec);
        return this.commandExecutor.writeBatchedAsync(jsonCodec, RedisCommands.JSON_MSET, new VoidSlotCallback(){

            @Override
            public Object[] createParams(List<Object> keys) {
                ArrayList<Object> params = new ArrayList<Object>(keys.size());
                for (Object key : keys) {
                    params.add(key);
                    params.add(path);
                    try {
                        params.add(jsonCodec.getValueEncoder().encode(mappedBuckets.get(key)));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return params.toArray();
            }
        }, mappedBuckets.keySet().toArray(new Object[0]));
    }
}

