/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import java.util.Map;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.mapreduce.RMapper;
import org.redisson.client.codec.Codec;
import org.redisson.mapreduce.BaseMapperTask;
import org.redisson.mapreduce.Collector;
import org.redisson.misc.Injector;

public class MapperTask<KIn, VIn, KOut, VOut>
extends BaseMapperTask<KOut, VOut> {
    private static final long serialVersionUID = 2441161019495880394L;
    protected RMapper<KIn, VIn, KOut, VOut> mapper;

    public MapperTask() {
    }

    public MapperTask(RMapper<KIn, VIn, KOut, VOut> mapper, Class<?> objectClass, Class<?> objectCodecClass) {
        super(objectClass, objectCodecClass);
        this.mapper = mapper;
    }

    @Override
    public void run() {
        Codec codec;
        try {
            codec = (Codec)this.objectCodecClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Injector.inject(this.mapper, this.redisson);
        Collector collector = new Collector(codec, this.redisson, this.collectorMapName, this.workersAmount, this.timeout);
        for (String objectName : this.objectNames) {
            RMap map = null;
            map = RMapCache.class.isAssignableFrom(this.objectClass) ? this.redisson.getMapCache(objectName, codec) : this.redisson.getMap(objectName, codec);
            for (Map.Entry entry : map.entrySet()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.mapper.map(entry.getKey(), entry.getValue(), collector);
            }
        }
    }
}

