/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;

public class ExtractTool {
    private static void writeWarcHeaders(WritableByteChannel out, WarcRecord record) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(record.version().toString()).append("\r\n");
        record.headers().appendTo(sb);
        sb.append("\r\n");
        out.write(ByteBuffer.wrap(sb.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private static void writeHttpHeaders(WritableByteChannel out, WarcRecord record) throws IOException {
        if (record instanceof WarcResponse) {
            HttpResponse response = ((WarcResponse)record).http();
            out.write(ByteBuffer.wrap(response.serializeHeader()));
        } else if (record instanceof WarcRequest) {
            HttpRequest request = ((WarcRequest)record).http();
            out.write(ByteBuffer.wrap(request.serializeHeader()));
        }
    }

    private static void writePayload(WritableByteChannel out, WarcRecord record) throws IOException {
        try {
            MessageBody payload;
            if (record instanceof WarcResponse) {
                if (record.contentType().base().equals(MediaType.HTTP)) {
                    HttpResponse response = ((WarcResponse)record).http();
                    payload = response.bodyDecoded();
                } else {
                    payload = ((WarcResponse)record).payload().map(WarcPayload::body).orElse(MessageBody.empty());
                }
            } else if (record instanceof WarcRequest) {
                if (record.contentType().base().equals(MediaType.HTTP)) {
                    HttpRequest request = ((WarcRequest)record).http();
                    payload = request.bodyDecoded();
                } else {
                    payload = ((WarcRequest)record).payload().map(WarcPayload::body).orElse(MessageBody.empty());
                }
            } else {
                payload = record.body();
            }
            ExtractTool.writeBody(out, payload);
        }
        catch (IOException e) {
            System.err.println("Failed to read payload: " + e.getMessage());
        }
    }

    private static void writeBody(WritableByteChannel out, ReadableByteChannel body) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        while (body.read(buffer) > -1) {
            buffer.flip();
            out.write(buffer);
            buffer.compact();
        }
    }

    private static void usage(int exitValue) {
        System.err.println();
        System.err.println("ExtractTool [-h] [--payload | --headers] filename offset ...");
        System.err.println();
        System.err.println("Options:");
        System.err.println();
        System.err.println(" --headers\toutput only record (and HTTP) headers");
        System.err.println(" --payload\toutput only record payload, if necessary");
        System.err.println("          \tdecode transfer and/or content encoding");
        System.exit(exitValue);
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException {
        action = ExtractAction.RECORD;
        warcFile = null;
        offsets = new ArrayList<Long>();
        block36: for (String arg : args) {
            var8_9 = arg;
            var9_10 = -1;
            switch (var8_9.hashCode()) {
                case 1499: {
                    if (!var8_9.equals("-h")) break;
                    var9_10 = 0;
                    break;
                }
                case 1333069025: {
                    if (!var8_9.equals("--help")) break;
                    var9_10 = 1;
                    break;
                }
                case -2113677850: {
                    if (!var8_9.equals("--headers")) break;
                    var9_10 = 2;
                    break;
                }
                case 599279598: {
                    if (!var8_9.equals("--payload")) break;
                    var9_10 = 3;
                }
            }
            switch (var9_10) {
                case 0: 
                case 1: {
                    ExtractTool.usage(0);
                }
                case 2: {
                    action = ExtractAction.HEADERS;
                    continue block36;
                }
                case 3: {
                    action = ExtractAction.PAYLOAD;
                    continue block36;
                }
                default: {
                    if (warcFile == null) {
                        warcFile = Paths.get(arg, new String[0]);
                        if (warcFile.toFile().canRead()) continue block36;
                        System.err.println("Cannot read WARC file: " + warcFile);
                        ExtractTool.usage(1);
                        continue block36;
                    }
                    if (arg.startsWith("-")) {
                        System.err.println("Unknown argument: " + arg);
                        ExtractTool.usage(1);
                        continue block36;
                    }
                    try {
                        offsets.add(Long.parseLong(arg));
                        continue block36;
                    }
                    catch (NumberFormatException e) {
                        System.err.println(e.getMessage());
                        ExtractTool.usage(1);
                    }
                }
            }
        }
        if (warcFile == null || offsets.isEmpty()) {
            ExtractTool.usage(1);
        }
        var4_4 = offsets.iterator();
lbl54:
        // 13 sources

        block37: while (var4_4.hasNext()) {
            offset = (Long)var4_4.next();
            channel = FileChannel.open(warcFile, new OpenOption[0]);
            var8_9 = null;
            try {
                reader = new WarcReader(channel.position(offset));
                var10_16 = null;
                try {
                    record = reader.next();
                    if (!record.isPresent()) {
                        System.err.println("No record found at position " + offset);
                        System.exit(1);
                    }
                    out = Channels.newChannel(System.out);
                    switch (1.$SwitchMap$org$netpreserve$jwarc$tools$ExtractTool$ExtractAction[action.ordinal()]) {
                        case 1: {
                            ExtractTool.writeWarcHeaders(out, record.get());
                            ExtractTool.writeBody(out, record.get().body());
                            out.write(ByteBuffer.wrap("\r\n\r\n".getBytes(StandardCharsets.US_ASCII)));
                            ** break;
                        }
                        case 2: {
                            ExtractTool.writeWarcHeaders(out, record.get());
                            ExtractTool.writeHttpHeaders(out, record.get());
                            ** break;
                        }
                        case 3: {
                            ExtractTool.writePayload(out, record.get());
                            continue block37;
                        }
                        ** default:
lbl82:
                        // 1 sources

                        continue block37;
                    }
                }
                catch (Throwable var11_19) {
                    var10_16 = var11_19;
                    throw var11_19;
                }
                finally {
                    if (reader == null) continue;
                    if (var10_16 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable var11_18) {
                            var10_16.addSuppressed(var11_18);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Throwable var9_14) {
                var8_9 = var9_14;
                throw var9_14;
            }
            finally {
                if (channel == null) continue;
                if (var8_9 != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable var9_13) {
                        var8_9.addSuppressed(var9_13);
                    }
                    continue;
                }
                channel.close();
            }
        }
    }

    private static enum ExtractAction {
        RECORD,
        HEADERS,
        PAYLOAD;

    }
}

