/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.feature;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.Feature;
import org.jetlinks.reactor.ql.utils.CastUtils;
import reactor.core.publisher.Flux;

public interface GroupFeature
extends Feature {
    public static final String groupByKeyContext = "_group_by_key";

    public static List<Object> getGroupKey(ReactorQLRecord context) {
        return context.getRecord(groupByKeyContext).map(CastUtils::castArray).orElseGet(Collections::emptyList);
    }

    public static ReactorQLRecord writeGroupKey(ReactorQLRecord record, Object key) {
        List<Object> list = GroupFeature.getGroupKey(record);
        if (CollectionUtils.isEmpty(list)) {
            list = new LinkedList<Object>();
            record.addRecord(groupByKeyContext, list);
        }
        list.add(key);
        return record;
    }

    public Function<Flux<ReactorQLRecord>, Flux<Flux<ReactorQLRecord>>> createGroupMapper(Expression var1, ReactorQLMetadata var2);
}

