/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.feature;

import org.jetlinks.reactor.ql.feature.DistinctFeature;
import org.jetlinks.reactor.ql.feature.Feature;
import org.jetlinks.reactor.ql.feature.FilterFeature;
import org.jetlinks.reactor.ql.feature.FromFeature;
import org.jetlinks.reactor.ql.feature.GroupFeature;
import org.jetlinks.reactor.ql.feature.ValueAggMapFeature;
import org.jetlinks.reactor.ql.feature.ValueFlatMapFeature;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;

public interface FeatureId<T extends Feature> {
    public String getId();

    public static <T extends Feature> FeatureId<T> of(String id) {
        return () -> id;
    }

    public static interface Distinct {
        public static final FeatureId<DistinctFeature> defaultId = Distinct.of("default");

        public static FeatureId<DistinctFeature> of(String type) {
            return FeatureId.of("distinct:".concat(type));
        }
    }

    public static interface From {
        public static final FeatureId<FromFeature> table = From.of("table");
        public static final FeatureId<FromFeature> values = From.of("values");
        public static final FeatureId<FromFeature> subSelect = From.of("subSelect");

        public static FeatureId<FromFeature> of(String type) {
            return FeatureId.of("from:".concat(type));
        }
    }

    public static interface Filter {
        public static final FeatureId<FilterFeature> between = Filter.of("between");
        public static final FeatureId<FilterFeature> in = Filter.of("in");
        public static final FeatureId<FilterFeature> and = Filter.of("and");
        public static final FeatureId<FilterFeature> or = Filter.of("or");

        public static FeatureId<FilterFeature> of(String type) {
            return FeatureId.of("filter:".concat(type));
        }
    }

    public static interface ValueAggMap {
        public static FeatureId<ValueAggMapFeature> of(String type) {
            return FeatureId.of("value-agg:".concat(type));
        }
    }

    public static interface ValueMap {
        public static final FeatureId<ValueMapFeature> property = ValueMap.of("property");
        public static final FeatureId<ValueMapFeature> cast = ValueMap.of("cast");
        public static final FeatureId<ValueMapFeature> caseWhen = ValueMap.of("case");
        public static final FeatureId<ValueMapFeature> select = ValueMap.of("select");

        public static FeatureId<ValueMapFeature> of(String type) {
            return FeatureId.of("value-map:".concat(type));
        }
    }

    public static interface ValueFlatMap {
        public static FeatureId<ValueFlatMapFeature> of(String type) {
            return FeatureId.of("flat-map:".concat(type));
        }
    }

    public static interface GroupBy {
        public static final FeatureId<GroupFeature> property = GroupBy.of("property");
        public static final FeatureId<GroupFeature> interval = GroupBy.of("interval");

        public static FeatureId<GroupFeature> of(String type) {
            return FeatureId.of("group-by:".concat(type));
        }
    }
}

