/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.jetlinks.reactor.ql.utils.SqlUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class DefaultReactorQLContext
implements ReactorQLContext {
    private final Function<String, Flux<Object>> supplier;
    private final List<Object> parameter;
    private volatile Map<String, Object> namedParameter;
    private BiFunction<String, Flux<Object>, Flux<Object>> mapper = (s, flux) -> flux;

    public DefaultReactorQLContext(Function<String, ? extends Publisher<?>> supplier) {
        this.supplier = name -> Flux.from((Publisher)((Publisher)supplier.apply((String)name)));
        this.parameter = new ArrayList<Object>();
    }

    public DefaultReactorQLContext(Function<String, ? extends Publisher<?>> supplier, List<Object> parameter) {
        this.supplier = name -> Flux.from((Publisher)((Publisher)supplier.apply((String)name)));
        this.parameter = parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> safeNamedParameters() {
        if (this.namedParameter == null) {
            DefaultReactorQLContext defaultReactorQLContext = this;
            synchronized (defaultReactorQLContext) {
                if (this.namedParameter == null) {
                    this.namedParameter = new HashMap<String, Object>();
                }
            }
        }
        return this.namedParameter;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.safeNamedParameters();
    }

    @Override
    public ReactorQLContext bind(Object value) {
        this.parameter.add(value);
        return this;
    }

    @Override
    public ReactorQLContext bind(int index, Object value) {
        this.parameter.add(index, value);
        return this;
    }

    @Override
    public ReactorQLContext bind(String name, Object value) {
        if (name != null && value != null) {
            this.safeNamedParameters().put(name, value);
        }
        return this;
    }

    @Override
    public Flux<Object> getDataSource(String name) {
        name = SqlUtils.getCleanStr(name);
        return this.mapper.apply(name, this.supplier.apply(name));
    }

    @Override
    public Optional<Object> getParameter(int index) {
        if (this.parameter.size() <= index) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.parameter.get(index));
    }

    @Override
    public Optional<Object> getParameter(String name) {
        if (this.namedParameter == null || this.namedParameter.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.namedParameter.get(SqlUtils.getCleanStr(name)));
    }

    @Override
    public ReactorQLContext transfer(BiFunction<String, Flux<Object>, Flux<Object>> dataSourceMapper) {
        DefaultReactorQLContext context = new DefaultReactorQLContext(this.supplier);
        context.mapper = dataSourceMapper;
        return context;
    }
}

