/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.reactor.ql.DefaultReactorQL;
import org.jetlinks.reactor.ql.ReactorQL;
import org.jetlinks.reactor.ql.feature.Feature;
import org.jetlinks.reactor.ql.supports.DefaultReactorQLMetadata;

class DefaultReactorQLBuilder
implements ReactorQL.Builder {
    private String sql;
    private final List<Feature> features = new ArrayList<Feature>();
    private final Map<String, Object> settings = new HashMap<String, Object>();

    DefaultReactorQLBuilder() {
    }

    @Override
    public ReactorQL.Builder sql(String ... sql) {
        this.sql = String.join((CharSequence)" ", sql);
        return this;
    }

    @Override
    public ReactorQL.Builder feature(Feature ... features) {
        this.features.addAll(Arrays.asList(features));
        return this;
    }

    @Override
    public ReactorQL.Builder setting(String key, Object value) {
        this.settings.put(key, value);
        return this;
    }

    @Override
    public ReactorQL.Builder settings(Map<String, Object> settings) {
        this.settings.putAll(settings);
        return this;
    }

    @Override
    public ReactorQL build() {
        DefaultReactorQLMetadata metadata = new DefaultReactorQLMetadata(this.sql);
        metadata.addFeature(this.features);
        this.settings.forEach(metadata::setting);
        return new DefaultReactorQL(metadata);
    }
}

