/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class JsonFieldExtractor {
    private final String fieldPath;
    private final List<String> pathSegments;
    private final ObjectMapper mapper;

    public JsonFieldExtractor(String fieldPath, ObjectMapper mapper) {
        this.fieldPath = fieldPath;
        this.pathSegments = Arrays.asList(fieldPath.split("\\."));
        this.mapper = mapper;
    }

    public <T> Flux<T> extractField(Flux<DataBuffer> stream, Class<T> valueType) {
        return DataBufferUtils.join(stream).flatMapMany(bytes -> Flux.create(sink -> {
            try (JsonParser parser = this.mapper.getFactory().createParser(bytes.asInputStream(true));){
                this.parseJsonStreamForField(parser, this.pathSegments, 0, (FluxSink)sink, valueType);
                sink.complete();
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
        })).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private <T> void parseJsonStreamForField(JsonParser parser, List<String> pathSegments, int currentDepth, FluxSink<T> sink, Class<T> valueType) {
        JsonToken token;
        block4: while ((token = parser.nextToken()) != null) {
            if (sink.isCancelled()) return;
            if (token != JsonToken.FIELD_NAME) continue;
            String fieldName = parser.getCurrentName();
            if (currentDepth < pathSegments.size() && fieldName.equals(pathSegments.get(currentDepth))) {
                JsonToken valueToken = parser.nextToken();
                if (currentDepth == pathSegments.size() - 1) {
                    if (valueToken == JsonToken.START_ARRAY) {
                        this.extractArrayValuesEfficiently(parser, sink, valueType);
                        continue;
                    }
                    if (valueToken == JsonToken.VALUE_NULL) continue;
                    try {
                        Object value = this.mapper.readValue(parser, valueType);
                        if (value == null) continue;
                        sink.next(value);
                        continue;
                    }
                    catch (Throwable e) {
                        sink.error(e);
                        continue;
                    }
                }
                if (valueToken == JsonToken.START_OBJECT) {
                    this.parseJsonStreamForField(parser, pathSegments, currentDepth + 1, sink, valueType);
                    continue;
                }
                if (valueToken != JsonToken.START_ARRAY) continue;
                while (true) {
                    if (parser.nextToken() == JsonToken.END_ARRAY || sink.isCancelled()) continue block4;
                    if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                    this.parseJsonStreamForField(parser, pathSegments, currentDepth + 1, sink, valueType);
                }
            }
            parser.nextToken();
            parser.skipChildren();
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> void extractArrayValuesEfficiently(JsonParser parser, FluxSink<T> sink, Class<T> valueType) {
        JsonToken token;
        while ((token = parser.nextToken()) != null && token != JsonToken.END_ARRAY && !sink.isCancelled()) {
            if (token == JsonToken.VALUE_NULL) continue;
            try {
                Object value = this.mapper.readValue(parser, valueType);
                if (value == null) continue;
                sink.next(value);
            }
            catch (Exception exception) {}
        }
        return;
    }
}

