/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.notify.cmd;

import com.google.common.collect.Maps;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.utils.SerializeUtils;

public class NotifyResult
implements Externalizable {
    public static final int STATE_SUCCESS = 0;
    public static final int STATE_QUEUED = 1;
    private int state;
    private String callId;
    private List<String> receiver;
    private String message;
    private Map<String, Object> others;

    public static NotifyResult ok() {
        return NotifyResult.of(0);
    }

    public static NotifyResult of(int state) {
        NotifyResult result = new NotifyResult();
        result.state = state;
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.state);
        SerializeUtils.writeNullableUTF((String)this.callId, (ObjectOutput)out);
        SerializeUtils.writeObject(this.receiver, (ObjectOutput)out);
        SerializeUtils.writeNullableUTF((String)this.message, (ObjectOutput)out);
        SerializeUtils.writeKeyValue(this.others, (ObjectOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.state = in.read();
        this.callId = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.receiver = (List)SerializeUtils.readObjectAs((ObjectInput)in);
        this.message = SerializeUtils.readNullableUTF((ObjectInput)in);
        this.others = SerializeUtils.readMap((ObjectInput)in, Maps::newHashMapWithExpectedSize);
    }

    public int getState() {
        return this.state;
    }

    public String getCallId() {
        return this.callId;
    }

    public List<String> getReceiver() {
        return this.receiver;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, Object> getOthers() {
        return this.others;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public void setReceiver(List<String> receiver) {
        this.receiver = receiver;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setOthers(Map<String, Object> others) {
        this.others = others;
    }
}

