/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.media;

import java.net.URI;
import java.util.Arrays;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.SimpleFunctionMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.sdk.server.media.MediaInfo;
import org.jetlinks.sdk.server.utils.CastUtils;
import reactor.core.publisher.Mono;

public class ProxyMediaStreamCommand
extends AbstractCommand<Mono<MediaInfo>, ProxyMediaStreamCommand> {
    public String getStreamId() {
        return (String)this.readable().get("streamId");
    }

    public String getSource() {
        return (String)this.readable().get("source");
    }

    public String getTarget() {
        return (String)this.readable().get("target");
    }

    public boolean isLocalPlayer() {
        return CastUtils.castBoolean(this.readable().get("localPlayer"));
    }

    public ProxyMediaStreamCommand withStreamId(String streamId) {
        this.with("streamId", streamId);
        return this;
    }

    public ProxyMediaStreamCommand withSource(URI sourceUri) {
        this.with("source", sourceUri == null ? null : sourceUri.toString());
        return this;
    }

    public ProxyMediaStreamCommand withTarget(URI targetUri) {
        this.with("target", targetUri == null ? null : targetUri.toString());
        return this;
    }

    public ProxyMediaStreamCommand withSource(String sourceUri) {
        this.with("source", sourceUri);
        return this;
    }

    public ProxyMediaStreamCommand withTarget(String targetUri) {
        this.with("target", targetUri);
        return this;
    }

    public ProxyMediaStreamCommand withLocalPlayer(boolean localPlayer) {
        this.with("localPlayer", localPlayer);
        return this;
    }

    public static FunctionMetadata metadata() {
        SimpleFunctionMetadata metadata = new SimpleFunctionMetadata();
        metadata.setId(CommandUtils.getCommandIdByType(ProxyMediaStreamCommand.class));
        metadata.setName("\u4ee3\u7406\u89c6\u9891\u6d41");
        metadata.setInputs(Arrays.asList(SimplePropertyMetadata.of((String)"streamId", (String)"\u6d41ID", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)"source", (String)"\u6e90\u5730\u5740", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)"target", (String)"\u76ee\u6807\u5730\u5740", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)"localPlayer", (String)"\u672c\u5730\u64ad\u653e", (DataType)StringType.GLOBAL)));
        metadata.setOutput((DataType)new ObjectType().addProperty("streamId", "\u6d41ID", (DataType)StringType.GLOBAL).addProperty("rtsp", "rtsp\u5730\u5740", (DataType)StringType.GLOBAL).addProperty("mp4", "mp4\u5730\u5740", (DataType)StringType.GLOBAL).addProperty("flv", "flv\u5730\u5740", (DataType)StringType.GLOBAL));
        return metadata;
    }
}

