/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.device.cmd;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.function.Function;
import javax.validation.constraints.NotBlank;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandMetadataResolver;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.sdk.server.commons.cmd.QueryCommand;
import org.jetlinks.sdk.server.device.DeviceProperty;
import org.jetlinks.sdk.server.ui.field.annotation.field.form.QueryComponent;
import org.jetlinks.sdk.server.ui.field.annotation.field.select.DeviceSelector;
import org.jetlinks.sdk.server.utils.ConverterUtils;
import reactor.core.publisher.Flux;

@Schema(title="\u6309\u6761\u4ef6\u67e5\u8be2\u6307\u5b9aID\u8bbe\u5907\u7684\u6307\u5b9a\u5c5e\u6027", description="\u82e5\u672a\u6307\u5b9a\u5c5e\u6027\uff0c\u5219\u67e5\u8be2\u8bbe\u5907\u5168\u90e8\u5c5e\u6027")
@QueryComponent(fields=DeviceProperty.class)
public class QueryPropertyEachCommand
extends QueryCommand<Flux<DeviceProperty>, QueryPropertyEachCommand> {
    public String getDeviceId() {
        return (String)this.readable().get("deviceId");
    }

    public QueryPropertyEachCommand withDeviceId(String deviceId) {
        this.writable().put("deviceId", deviceId);
        return this;
    }

    public List<String> getProperties() {
        return ConverterUtils.convertToList(this.readable().get("properties"), String::valueOf);
    }

    public QueryPropertyEachCommand withProperties(List<String> properties) {
        this.writable().put("properties", properties);
        return this;
    }

    public static CommandHandler<QueryPropertyEachCommand, Flux<DeviceProperty>> createHandler(Function<QueryPropertyEachCommand, Flux<DeviceProperty>> handler) {
        return CommandHandler.of(QueryPropertyEachCommand::metadata, (cmd, ignore) -> (Flux)handler.apply((QueryPropertyEachCommand)((Object)cmd)), QueryPropertyEachCommand::new);
    }

    public static FunctionMetadata metadata() {
        return CommandMetadataResolver.resolve(QueryPropertyEachCommand.class);
    }

    protected static class InputSpec
    extends QueryCommand.InputSpec {
        @DeviceSelector
        @NotBlank
        @Schema(title="\u8bbe\u5907ID")
        private String deviceId;
        @Schema(title="\u7269\u6a21\u578b\u5c5e\u6027ID")
        private List<String> properties;

        protected InputSpec() {
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public void setProperties(List<String> properties) {
            this.properties = properties;
        }
    }
}

