/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.sdk.server.auth.cmd;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.jetlinks.core.command.AbstractConvertCommand;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.SimpleFunctionMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.sdk.server.auth.DimensionUserBindInfo;
import org.jetlinks.sdk.server.auth.DimensionUserBindRequest;
import org.jetlinks.sdk.server.utils.ConverterUtils;
import org.springframework.core.ResolvableType;
import reactor.core.publisher.Flux;

public class GetDimensionUserBindCommand
extends AbstractConvertCommand<Flux<DimensionUserBindInfo>, GetDimensionUserBindCommand> {
    private static final long serialVersionUID = 1L;

    public List<DimensionUserBindRequest> getDimensions() {
        return ConverterUtils.convertToList(this.readable().get("dimensions"), DimensionUserBindRequest::of);
    }

    public GetDimensionUserBindCommand withDimensions(Collection<DimensionUserBindRequest> dimensions) {
        this.writable().put("dimensions", dimensions);
        return this;
    }

    public GetDimensionUserBindCommand withDimension(String type, String id) {
        Collection dimensions = this.readable().getOrDefault("dimensions", new CopyOnWriteArrayList());
        dimensions.add(new DimensionUserBindRequest(type, id));
        return this;
    }

    public static CommandHandler<GetDimensionUserBindCommand, Flux<DimensionUserBindInfo>> createHandler(Function<GetDimensionUserBindCommand, Flux<DimensionUserBindInfo>> handler) {
        return CommandHandler.of(() -> {
            SimpleFunctionMetadata metadata = new SimpleFunctionMetadata();
            metadata.setId(CommandUtils.getCommandIdByType(GetDimensionUserBindCommand.class));
            metadata.setName("\u6839\u636e\u7ef4\u5ea6\u67e5\u8be2\u5bf9\u5e94\u7528\u6237id");
            metadata.setDescription("\u6839\u636e\u7ef4\u5ea6\u7c7b\u578bid\u67e5\u8be2\u5bf9\u5e94\u6240\u5c5e\u7684\u7528\u6237id");
            metadata.setInputs(Collections.singletonList(SimplePropertyMetadata.of((String)"dimensions", (String)"\u7ef4\u5ea6\u4fe1\u606f", (DataType)new ObjectType().addProperty("type", "\u7ef4\u5ea6\u7c7b\u578b", (DataType)StringType.GLOBAL).addProperty("id", "\u7ef4\u5ea6id", (DataType)StringType.GLOBAL))));
            return metadata;
        }, (cmd, ignore) -> (Flux)handler.apply((GetDimensionUserBindCommand)((Object)cmd)), () -> (GetDimensionUserBindCommand)new GetDimensionUserBindCommand().withConverter(CommandUtils.createConverter((ResolvableType)ResolvableType.forType(DimensionUserBindInfo.class))));
    }
}

