/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.plugin.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import org.jetlinks.core.command.AbstractCommandSupport;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.plugin.core.Plugin;
import org.jetlinks.plugin.core.PluginContext;
import org.jetlinks.plugin.core.PluginState;
import org.jetlinks.plugin.core.PluginType;
import org.jetlinks.supports.command.JavaBeanCommandSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

public abstract class AbstractPlugin
extends AbstractCommandSupport
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(AbstractPlugin.class);
    private static final AtomicReferenceFieldUpdater<AbstractPlugin, PluginState> STATE = AtomicReferenceFieldUpdater.newUpdater(AbstractPlugin.class, PluginState.class, "state");
    private final String id;
    private final PluginContext context;
    private volatile PluginState state = PluginState.stopped;
    private final List<BiConsumer<PluginState, PluginState>> stateListener = new CopyOnWriteArrayList<BiConsumer<PluginState, PluginState>>();

    public AbstractPlugin(String id, PluginContext context) {
        this.id = id;
        this.context = context;
        this.registerCommands(this);
    }

    protected PluginContext context() {
        return this.context;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public abstract PluginType getType();

    @Override
    public final PluginState getState() {
        return this.state;
    }

    @Override
    public final Mono<Void> start() {
        if (this.state == PluginState.starting || this.state == PluginState.running) {
            return Mono.empty();
        }
        this.changeState(PluginState.starting);
        return this.doStart().doOnSuccess(ignore -> this.changeState(PluginState.running)).doOnError(err -> this.changeState(PluginState.stopped));
    }

    protected Mono<Void> doStart() {
        return Mono.empty();
    }

    @Override
    public final Mono<Void> pause() {
        this.changeState(PluginState.paused);
        return this.doPause();
    }

    protected Mono<Void> doPause() {
        return Mono.empty();
    }

    @Override
    public final Mono<Void> shutdown() {
        this.changeState(PluginState.stopped);
        return this.doShutdown();
    }

    protected Mono<Void> doShutdown() {
        return Mono.empty();
    }

    protected PluginState changeState(PluginState state) {
        PluginState old = STATE.getAndSet(this, state);
        if (old != state) {
            this.fireStateChange(old, state);
        }
        return old;
    }

    @Override
    public final Disposable doOnSateChanged(BiConsumer<PluginState, PluginState> listener) {
        this.stateListener.add(listener);
        return () -> this.stateListener.remove(listener);
    }

    protected void fireStateChange(PluginState before, PluginState after) {
        log.debug("{} plugin [{}] state change from {} to {} ", new Object[]{this.getType().getId(), this.getId(), before, after});
        for (BiConsumer<PluginState, PluginState> listener : this.stateListener) {
            try {
                listener.accept(before, after);
            }
            catch (Throwable error) {
                log.warn("fire {} plugin [{}] state listener error", new Object[]{this.getType().getId(), this.getId(), error});
            }
        }
    }

    protected void registerCommands(Object instance) {
        new JavaBeanCommandSupport(instance).getHandlers().forEach(handler -> this.registerHandler(handler.getMetadata().getId(), (CommandHandler)handler));
    }
}

