/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.poi;

import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.compress.utils.Sets;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hswebframework.reactor.excel.BoundedCell;
import org.hswebframework.reactor.excel.CellDataType;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class PoiCell
implements BoundedCell {
    private int sheetIndex;
    private Cell cell;
    private boolean endOfRow;
    private Object value;
    static final Set<Integer> dateFormats = Sets.newHashSet((Object[])new Integer[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 32, 33, 34, 35, 36, 37, 45, 46, 47, 54, 31, 165, 166, 167, 168, 169});

    PoiCell(int sheetIndex, Cell cell, boolean end) {
        this.sheetIndex = sheetIndex;
        this.cell = cell;
        this.endOfRow = end;
        this.value = this.convertValue();
    }

    private Object convertToTime(double value) {
        long totalSeconds = (long)(value * 24.0 * 60.0 * 60.0);
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours >= 0L && hours < 24L && minutes >= 0L && seconds >= 0L) {
            return LocalTime.of((int)hours, (int)minutes, (int)seconds);
        }
        return value;
    }

    private Object convertValue() {
        if (this.cell == null) {
            return null;
        }
        return this.convertValueAndType().getT2();
    }

    private Tuple2<CellDataType, Object> convertValueAndType() {
        switch (this.cell.getCellType()) {
            case BOOLEAN: {
                return Tuples.of((Object)((Object)CellDataType.BOOLEAN), (Object)this.cell.getBooleanCellValue());
            }
            case NUMERIC: {
                if (this.isCellDateFormatted()) {
                    Date date = this.cell.getDateCellValue();
                    if (date.getTime() > 0L) {
                        return Tuples.of((Object)((Object)CellDataType.DATE_TIME), (Object)date);
                    }
                    return Tuples.of((Object)((Object)CellDataType.DATE_TIME), (Object)this.convertToTime(this.cell.getNumericCellValue()));
                }
                return Tuples.of((Object)((Object)CellDataType.NUMBER), (Object)this.convertToNumber(this.cell));
            }
            case STRING: {
                return Tuples.of((Object)((Object)CellDataType.STRING), (Object)this.cell.getRichStringCellValue().getString());
            }
            case FORMULA: {
                FormulaEvaluator evaluator = this.cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(this.cell);
                switch (cellValue.getCellType()) {
                    case BOOLEAN: {
                        return Tuples.of((Object)((Object)CellDataType.BOOLEAN), (Object)cellValue.getBooleanValue());
                    }
                    case NUMERIC: {
                        if (this.isCellDateFormatted()) {
                            Workbook workbook = this.cell.getRow().getSheet().getWorkbook();
                            if (workbook instanceof XSSFWorkbook) {
                                Date date = DateUtil.getJavaDate((double)cellValue.getNumberValue(), (boolean)((XSSFWorkbook)workbook).isDate1904());
                                if (date.getTime() > 0L) {
                                    return Tuples.of((Object)((Object)CellDataType.DATE_TIME), (Object)date);
                                }
                                return Tuples.of((Object)((Object)CellDataType.DATE_TIME), (Object)this.convertToTime(cellValue.getNumberValue()));
                            }
                            return Tuples.of((Object)((Object)CellDataType.NUMBER), (Object)cellValue.getNumberValue());
                        }
                        return Tuples.of((Object)((Object)CellDataType.NUMBER), (Object)cellValue.getNumberValue());
                    }
                    case BLANK: {
                        return Tuples.of((Object)((Object)CellDataType.AUTO), (Object)"");
                    }
                }
                return Tuples.of((Object)((Object)CellDataType.STRING), (Object)cellValue.getStringValue());
            }
        }
        return Tuples.of((Object)((Object)CellDataType.STRING), (Object)this.cell.getStringCellValue());
    }

    private Number convertToNumber(Cell cell) {
        BigDecimal value = new BigDecimal(cell.toString());
        if (value.scale() == 0) {
            return value.longValue();
        }
        BigDecimal[] result = value.divideAndRemainder(BigDecimal.ONE);
        if (result[1].equals(BigDecimal.valueOf(0.0))) {
            return value.longValue();
        }
        return value;
    }

    public boolean isCellDateFormatted() {
        if (this.cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = this.cell.getNumericCellValue();
        if (DateUtil.isValidExcelDate((double)d)) {
            CellStyle style = this.cell.getCellStyle();
            if (style == null) {
                return false;
            }
            short i = style.getDataFormat();
            if (dateFormats.contains(i)) {
                return true;
            }
            String f = style.getDataFormatString();
            f = f.replaceAll("[\"|']", "").replaceAll("[\u5e74|\u6708|\u65e5|\u65f6|\u5206|\u79d2|\u6beb\u79d2|\u5fae\u79d2]", "");
            bDate = DateUtil.isADateFormat((int)i, (String)f);
        }
        return bDate;
    }

    @Override
    public int getSheetIndex() {
        return this.sheetIndex;
    }

    @Override
    public String getSheetName() {
        return this.cell.getSheet().getSheetName();
    }

    @Override
    public long getRowIndex() {
        return this.cell.getRowIndex();
    }

    @Override
    public int getColumnIndex() {
        return this.cell.getColumnIndex();
    }

    @Override
    public int getNumberOfColumns() {
        return this.cell.getRow().getPhysicalNumberOfCells();
    }

    @Override
    public int getNumberOfSheets() {
        return this.cell.getSheet().getWorkbook().getNumberOfSheets();
    }

    @Override
    public int getNumberOfRows() {
        return this.cell.getSheet().getPhysicalNumberOfRows();
    }

    @Override
    public Optional<Object> value() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public CellDataType getType() {
        if (this.cell == null) {
            return CellDataType.AUTO;
        }
        return (CellDataType)((Object)this.convertValueAndType().getT1());
    }

    public Cell getCell() {
        return this.cell;
    }

    @Override
    public boolean isEndOfRow() {
        return this.endOfRow;
    }

    public Object getValue() {
        return this.value;
    }

    public PoiCell(int sheetIndex, Cell cell, boolean endOfRow, Object value) {
        this.sheetIndex = sheetIndex;
        this.cell = cell;
        this.endOfRow = endOfRow;
        this.value = value;
    }
}

