/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.utils.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.utils.time.Utils;

public class SmartDateFormatter
implements DateFormatter {
    public static final Part year_cn = SmartDateFormatter.str("\u5e74");
    public static final Part month_cn = SmartDateFormatter.str("\u6708");
    public static final Part day_cn = SmartDateFormatter.str("\u65e5");
    public static final Part hour_cn = SmartDateFormatter.str("\u65f6");
    public static final Part minute_cn = SmartDateFormatter.str("\u5206");
    public static final Part second_cn = SmartDateFormatter.str("\u79d2");
    public static final Part weeks3 = new Week("EEE", 3);
    public static final Part month3 = new Month("MMM", 3);
    public static final Part zzz = new TimezonePart("zzz", 3);
    public static final Part strike = SmartDateFormatter.str("-");
    public static final Part slash = SmartDateFormatter.str("/");
    public static final Part plus = SmartDateFormatter.str("+");
    public static final Part blankSpace = SmartDateFormatter.str(" ");
    public static final Part colon = SmartDateFormatter.str(":");
    public static final Part yyyy = new NumberPart("yyyy", 1900, 2999);
    public static final Part MM = new NumberPart("MM", 1, 12);
    public static final Part M = new NumberPart("M", 1, 12);
    public static final Part dd = new NumberPart("dd", 1, 31);
    public static final Part d = new NumberPart("d", 1, 31);
    public static final Part HH = new NumberPart("HH", 0, 23);
    public static final Part k = new NumberPart("k", 1, 24);
    public static final Part K = new NumberPart("K", 0, 11);
    public static final Part a = new MatchPart("a", 2, new HashSet<String>(Arrays.asList("AM", "PM")));
    public static final Part h = new NumberPart("h", 1, 12);
    public static final Part H = new NumberPart("H", 0, 24);
    public static final Part mm = new NumberPart("mm", 0, 60);
    public static final Part m = new NumberPart("m", 0, 60);
    public static final Part ss = new NumberPart("ss", 0, 60);
    public static final Part SSS = new NumberPart("SSS", 3, 0, 999);
    public static final Part s = new NumberPart("s", 0, 60);
    public static final Part Z = new NumberPart("Z", 4, 0, 9999);
    public static final Part XXX = new ZoneOffsetPart();
    public static final Part T = SmartDateFormatter.str("T");
    DateTimeFormatter pattern;
    final String patternString;
    private final Part[] parts;
    private final int max;
    private final int min;

    public SmartDateFormatter withLocal(Locale locale) {
        this.pattern = this.pattern.withLocale(locale);
        return this;
    }

    SmartDateFormatter(String pattern, int max, int min, Part[] parts) {
        this.parts = parts;
        this.max = max;
        this.min = min;
        this.patternString = pattern;
        this.pattern = DateTimeFormatter.ofPattern(this.patternString);
    }

    SmartDateFormatter(String pattern, Part[] parts) {
        this.parts = parts;
        this.min = this.max = Stream.of(this.parts).mapToInt(Part::length).sum();
        this.patternString = pattern;
        this.pattern = DateTimeFormatter.ofPattern(this.patternString);
    }

    SmartDateFormatter(Part[] parts) {
        this.parts = parts;
        this.min = this.max = Stream.of(this.parts).mapToInt(Part::length).sum();
        this.patternString = Stream.of(this.parts).map(Part::pattern).collect(Collectors.joining());
        this.pattern = DateTimeFormatter.ofPattern(this.patternString);
    }

    public static SmartDateFormatter of(String pattern, Part ... parts) {
        return new SmartDateFormatter(pattern, parts);
    }

    public static SmartDateFormatter of(String pattern, int min, int max, Part ... parts) {
        return new SmartDateFormatter(pattern, max, min, parts);
    }

    public static SmartDateFormatter of(Part ... parts) {
        return new SmartDateFormatter(parts);
    }

    @Override
    public boolean support(String str) {
        int len = str.length();
        if (len < this.min || len > this.max) {
            return false;
        }
        int temp = 0;
        for (Part part : this.parts) {
            if (!part.test(str, temp)) {
                return false;
            }
            temp += part.length();
        }
        return true;
    }

    @Override
    public Date format(String str) {
        return Date.from(this.parse(str).atZone(ZoneId.systemDefault()).toInstant());
    }

    @Override
    public LocalDateTime parse(String str) {
        TemporalAccessor accessor = this.pattern.parse(str);
        LocalDate date = accessor.query(TemporalQueries.localDate());
        LocalTime time = accessor.query(TemporalQueries.localTime());
        ZoneId zoneId = accessor.query(TemporalQueries.zone());
        ZoneOffset offset = accessor.query(TemporalQueries.offset());
        LocalDateTime dateTime = date != null ? (time != null ? LocalDateTime.of(date, time) : LocalDateTime.of(date, LocalTime.of(0, 0, 0, 0))) : LocalDateTime.of(LocalDate.now(), time);
        if (offset != null) {
            return dateTime.atOffset(offset).toLocalDateTime();
        }
        if (zoneId != null) {
            return dateTime.atZone(zoneId).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
        }
        return dateTime.atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    @Override
    public String toString(Date date) {
        return this.pattern.format(ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    @Override
    public String toString(LocalDateTime dateTime) {
        return this.pattern.format(dateTime.atZone(ZoneId.systemDefault()));
    }

    @Override
    public String getPattern() {
        return this.patternString;
    }

    public static Part str(String str) {
        return new StringPart(str);
    }

    public static interface Part {
        public int length();

        public String pattern();

        public boolean test(String var1, int var2);
    }

    static class MatchPart
    implements Part {
        private final Set<String> matched;
        private final String pattern;
        private final int length;

        MatchPart(String pattern, int length, Set<String> matched) {
            this.pattern = pattern;
            this.length = length;
            this.matched = matched;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public String pattern() {
            return this.pattern;
        }

        @Override
        public boolean test(String str, int offset) {
            return this.matched.contains(str.substring(offset, offset + this.length));
        }
    }

    static class Week
    extends MatchPart {
        static Set<String> WEEKS = new HashSet<String>(Arrays.asList("\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d", "\u661f\u671f\u65e5", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d", "\u5468\u65e5"));

        Week(String pattern, int length) {
            super(pattern, length, WEEKS);
        }
    }

    static class Month
    extends MatchPart {
        static Set<String> MONTHS = new HashSet<String>(Arrays.asList("\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"));

        Month(String pattern, int length) {
            super(pattern, length, MONTHS);
        }
    }

    static class NumberPart
    implements Part {
        private final String pattern;
        private final int length;
        private final int min;
        private final int max;

        NumberPart(String pattern, int length, int min, int max) {
            this.pattern = pattern;
            this.min = min;
            this.max = max;
            this.length = length;
        }

        NumberPart(String pattern, int min, int max) {
            this(pattern, pattern.length(), min, max);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public String pattern() {
            return this.pattern;
        }

        @Override
        public boolean test(String str, int offset) {
            int val = Utils.toNumber(str, offset, this.length);
            return val >= this.min && val <= this.max;
        }
    }

    static class ZoneOffsetPart
    implements Part {
        ZoneOffsetPart() {
        }

        @Override
        public int length() {
            return 6;
        }

        @Override
        public String pattern() {
            return "Z";
        }

        @Override
        public boolean test(String str, int offset) {
            if (str.charAt(offset) != '+' || str.charAt(offset + 3) != ':') {
                return false;
            }
            int hour = Utils.toNumber(str, offset + 1, 2);
            if (hour < 0 || hour > 12) {
                return false;
            }
            int minute = Utils.toNumber(str, offset + 4, 2);
            return minute >= 0;
        }
    }

    static class TimezonePart
    extends MatchPart {
        static Set<String> TZ = new HashSet<String>(Arrays.asList("CST", "GMT", "UTC"));

        TimezonePart(String pattern, int length) {
            super(pattern, length, TZ);
        }
    }

    static class StringPart
    implements Part {
        private final String pattern;
        private final int length;

        StringPart(String pattern) {
            this(pattern, pattern.length());
        }

        StringPart(String pattern, int length) {
            this.pattern = pattern;
            this.length = length;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public String pattern() {
            return this.pattern;
        }

        @Override
        public boolean test(String str, int offset) {
            for (int i = 0; i < this.pattern.length(); ++i) {
                if (str.charAt(offset + i) == this.pattern.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }
}

