/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.utils.RandomUtil;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.crud.service.ReactiveTreeSortEntityService;
import org.hswebframework.web.exception.ValidationException;
import org.reactivestreams.Publisher;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TreeSortServiceHelper<E extends TreeSortSupportEntity<PK>, PK> {
    private Map<PK, E> allData;
    private Map<PK, E> oldData;
    private Map<PK, E> thisTime;
    private Map<PK, E> readyToSave;
    private final Map<PK, Map<PK, E>> childrenMapping = new LinkedHashMap<PK, Map<PK, E>>();
    private final ReactiveTreeSortEntityService<E, PK> service;

    TreeSortServiceHelper(ReactiveTreeSortEntityService<E, PK> service) {
        this.service = service;
    }

    Flux<E> prepare(Flux<E> source) {
        Flux cache = source.flatMapIterable(e -> TreeSupportEntity.expandTree2List((TreeSupportEntity)e, this.service.getIDGenerator())).collectList().flatMapIterable(list -> {
            Map map = list.stream().filter(e -> e.getId() != null).collect(Collectors.toMap(TreeSupportEntity::getId, Function.identity(), (a, b) -> a));
            TreeSupportEntity.list2tree((Collection)list, this.service::setChildren, e -> this.service.isRootNode((TreeSortSupportEntity)e) || map.get(e.getParentId()) == null);
            return list;
        }).cache();
        return this.init(cache).then(Mono.defer(this::checkParentId)).then(Mono.fromRunnable(this::checkCyclicDependency)).then(Mono.fromRunnable(this::refactorPath)).thenMany((Publisher)Flux.defer(() -> Flux.fromIterable(this.readyToSave.values()))).doOnNext(this::refactor);
    }

    private Mono<Void> init(Flux<E> source) {
        this.oldData = new LinkedHashMap<PK, E>();
        this.thisTime = new LinkedHashMap<PK, E>();
        this.allData = new LinkedHashMap<PK, E>();
        this.readyToSave = new LinkedHashMap<PK, E>();
        Mono allDataFetcher = source.mapNotNull(e -> {
            if (e.getId() != null) {
                this.thisTime.put(e.getId(), e);
            }
            return e.getId();
        }).collect(Collectors.toSet()).flatMap(list -> this.service.queryIncludeChildren((Collection<PK>)list).collectMap(TreeSupportEntity::getId, Function.identity()));
        return allDataFetcher.doOnNext(includeChildren -> {
            for (TreeSortSupportEntity value : this.thisTime.values()) {
                TreeSortSupportEntity old = (TreeSortSupportEntity)includeChildren.get(value.getId());
                if (null == old) continue;
                this.oldData.put(value.getId(), old);
            }
            this.readyToSave.putAll(this.thisTime);
            this.allData.putAll((Map<PK, E>)includeChildren);
            this.allData.putAll(this.thisTime);
            this.initChildren();
        }).then();
    }

    private void initChildren() {
        this.childrenMapping.clear();
        for (TreeSortSupportEntity value : this.allData.values()) {
            if (this.service.isRootNode(value) || value.getId() == null) continue;
            this.childrenMapping.computeIfAbsent(value.getParentId(), ignore -> new LinkedHashMap()).put(value.getId(), value);
        }
    }

    private void checkCyclicDependency() {
        for (TreeSortSupportEntity value : this.readyToSave.values()) {
            this.checkCyclicDependency(value, new LinkedHashSet());
        }
    }

    private void checkCyclicDependency(E val, Set<PK> container) {
        if (!container.add(val.getId())) {
            throw new ValidationException("parentId", "error.tree_entity_cyclic_dependency", new Object[0]);
        }
        Map<PK, E> children = this.childrenMapping.get(val.getId());
        if (MapUtils.isNotEmpty(children)) {
            for (Map.Entry<PK, E> entry : children.entrySet()) {
                this.checkCyclicDependency((TreeSortSupportEntity)entry.getValue(), container);
            }
        }
    }

    private Mono<Void> checkParentId() {
        if (this.allData.isEmpty()) {
            return Mono.empty();
        }
        Set readyToCheck = this.thisTime.values().stream().map(TreeSupportEntity::getParentId).filter(e -> !ObjectUtils.isEmpty((Object)e) && !this.allData.containsKey(e)).collect(Collectors.toSet());
        if (readyToCheck.isEmpty()) {
            return Mono.empty();
        }
        return ((ReactiveQuery)this.service.createQuery().in("id", readyToCheck)).fetch().doOnNext(e -> {
            this.allData.put(e.getId(), e);
            readyToCheck.remove(e.getId());
        }).then(Mono.fromRunnable(() -> {
            if (!readyToCheck.isEmpty()) {
                throw new ValidationException("error.tree_entity_parent_id_not_exist", Collections.singletonList(new ValidationException.Detail("parentId", "error.tree_entity_parent_id_not_exist", (Object)readyToCheck)), new Object[0]);
            }
            this.initChildren();
        }));
    }

    private void refactorPath() {
        Function<Object, Collection> childGetter = id -> this.childrenMapping.getOrDefault(id, Collections.emptyMap()).values();
        for (TreeSortSupportEntity data : this.thisTime.values()) {
            TreeSortSupportEntity oldParent;
            TreeSortSupportEntity old = data.getId() == null ? null : (TreeSortSupportEntity)this.oldData.get(data.getId());
            Object parentId = old != null ? old.getParentId() : data.getParentId();
            TreeSortSupportEntity treeSortSupportEntity = oldParent = parentId == null ? null : (TreeSortSupportEntity)this.allData.get(parentId);
            if (old != null) {
                Object newParentId = data.getParentId();
                if (!Objects.equals(parentId, newParentId)) {
                    Consumer<TreeSortSupportEntity> childConsumer = child -> {
                        TreeSortSupportEntity readyToUpdate = (TreeSortSupportEntity)this.thisTime.get(child.getId());
                        if (null != readyToUpdate) {
                            readyToUpdate.setPath(child.getPath());
                        }
                    };
                    if (this.service.isRootNode(data)) {
                        data.setPath(RandomUtil.randomChar((int)4));
                        this.refactorChildPath(old.getId(), data.getPath(), childConsumer);
                        this.putChildToReadyToSave(childGetter, old);
                        continue;
                    }
                    TreeSortSupportEntity newParent = (TreeSortSupportEntity)this.allData.get(newParentId);
                    if (null == newParent) continue;
                    data.setPath(newParent.getPath() + "-" + RandomUtil.randomChar((int)4));
                    this.refactorChildPath(data.getId(), data.getPath(), childConsumer);
                    this.putChildToReadyToSave(childGetter, data);
                    continue;
                }
                if (oldParent != null) {
                    if (old.getPath().startsWith(oldParent.getPath())) {
                        data.setPath(old.getPath());
                        continue;
                    }
                    data.setPath(oldParent.getPath() + "-" + RandomUtil.randomChar((int)4));
                    continue;
                }
                data.setPath(old.getPath());
                continue;
            }
            if (parentId == null || oldParent == null) continue;
            data.setPath(oldParent.getPath() + "-" + RandomUtil.randomChar((int)4));
        }
    }

    private void putChildToReadyToSave(Function<PK, Collection<E>> childGetter, E data) {
        childGetter.apply(data.getId()).forEach(e -> {
            this.readyToSave.put(e.getId(), e);
            this.putChildToReadyToSave(childGetter, e);
        });
    }

    private void refactor(E e) {
        if (e.getPath() != null) {
            e.setLevel(Integer.valueOf(e.getPath().split("-").length));
        }
    }

    private void refactorChildPath(PK id, String path, Consumer<E> pathAccepter) {
        Collection children = this.childrenMapping.getOrDefault(id, Collections.emptyMap()).values();
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (TreeSortSupportEntity child : children) {
            if (ObjectUtils.isEmpty((Object)path)) {
                child.setPath(RandomUtil.randomChar((int)4));
            } else {
                child.setPath(path + "-" + RandomUtil.randomChar((int)4));
            }
            pathAccepter.accept(child);
            this.refactorChildPath(child.getId(), child.getPath(), pathAccepter);
        }
    }
}

