/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.exception;

import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hswebframework.web.crud.configuration.DialectProvider;
import org.hswebframework.web.crud.configuration.DialectProviders;
import org.hswebframework.web.exception.analyzer.ExceptionAnalyzerReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseExceptionAnalyzerReporter
extends ExceptionAnalyzerReporter {
    private static final Logger log = LoggerFactory.getLogger(DatabaseExceptionAnalyzerReporter.class);

    public DatabaseExceptionAnalyzerReporter() {
        this.init();
    }

    void init() {
        this.addSimpleReporter(Pattern.compile("^Binding.*"), error -> log.warn(DatabaseExceptionAnalyzerReporter.wrapLog((String)"\u8bf7\u5728application.yml\u4e2d\u6b63\u786e\u914d\u7f6e`easyorm.dialect`,\u53ef\u9009\u9879\u4e3a:{}"), DialectProviders.all().stream().map(DialectProvider::name).collect(Collectors.toList()), error));
        this.addSimpleReporter(Pattern.compile("^Unknown database.*"), error -> log.warn(DatabaseExceptionAnalyzerReporter.wrapLog((String)"\u8bf7\u5148\u624b\u52a8\u521b\u5efa\u6570\u636e\u5e93\u6216\u8005\u914d\u7f6e`easyorm.default-schema`,\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u5305\u542b\u53ea\u80fd\u7531`\u6570\u5b57\u5b57\u6bcd\u4e0b\u5212\u7ebf`\u7ec4\u6210."), error));
        this.addSimpleReporter(Pattern.compile("^Timeout on blocking.*"), error -> log.warn(DatabaseExceptionAnalyzerReporter.wrapLog((String)"\u64cd\u4f5c\u8d85\u65f6,\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u662f\u5426\u6b63\u786e,\u6570\u636e\u5e93\u662f\u5426\u80fd\u6b63\u5e38\u8bbf\u95ee."), error));
        this.initForPgsql();
        this.initRedis();
    }

    void initRedis() {
        this.addReporter(err -> err.getClass().getCanonicalName().contains("RedisConnectionException"), error -> log.warn(DatabaseExceptionAnalyzerReporter.wrapLog((String)"\u8bf7\u68c0\u67e5redis\u8fde\u63a5\u914d\u7f6e."), error));
    }

    void initForPgsql() {
        this.addSimpleReporter(Pattern.compile(".*\\[3D000].*"), error -> log.warn(DatabaseExceptionAnalyzerReporter.wrapLog((String)"\u8bf7\u5148\u624b\u52a8\u521b\u5efa\u6570\u636e\u5e93,\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u5305\u542b\u53ea\u80fd\u7531`\u6570\u5b57\u5b57\u6bcd\u4e0b\u5212\u7ebf`\u7ec4\u6210."), error));
        this.addSimpleReporter(Pattern.compile(".*\\[3F000].*"), error -> log.warn(DatabaseExceptionAnalyzerReporter.wrapLog((String)"\u8bf7\u6b63\u786e\u914d\u7f6e`easyorm.default-schema`\u4e3apgsql\u6570\u636e\u5e93\u4e2d\u5bf9\u5e94\u7684schema."), error));
        this.addReporter(err -> err.getClass().getCanonicalName().contains("PostgresConnectionException"), error -> log.warn(DatabaseExceptionAnalyzerReporter.wrapLog((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u662f\u5426\u6b63\u786e."), error));
    }
}

