/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.events;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.events.EventContext;
import org.hswebframework.ezorm.rdb.events.EventListener;
import org.hswebframework.ezorm.rdb.events.EventType;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.mapping.events.MappingEventTypes;
import org.hswebframework.ezorm.rdb.mapping.events.ReactiveResultHolder;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.authorization.Authentication;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class CreatorEventListener
implements EventListener,
Ordered {
    public String getId() {
        return "creator-listener";
    }

    public String getName() {
        return "\u521b\u5efa\u8005\u76d1\u542c\u5668";
    }

    public void onEvent(EventType type, EventContext context) {
        Optional resultHolder = context.get(MappingContextKeys.reactiveResultHolder);
        if (type == MappingEventTypes.insert_before || type == MappingEventTypes.save_before || type == MappingEventTypes.update_before) {
            if (resultHolder.isPresent()) {
                ReactiveResultHolder holder = (ReactiveResultHolder)resultHolder.get();
                holder.before(Mono.deferContextual(ctx -> Authentication.currentReactive().doOnNext(auth -> this.doApplyCreator((ContextView)ctx, type, context, (Authentication)auth)).then()));
            } else {
                Authentication.current().ifPresent(auth -> this.doApplyCreator((ContextView)Context.empty(), type, context, (Authentication)auth));
            }
        }
    }

    protected void doApplyCreator(ContextView ctx, EventType type, EventContext context, Authentication auth) {
        boolean applyUpdate;
        Object instance = context.get(MappingContextKeys.instance).orElse(null);
        boolean bl = applyUpdate = !RecordModifierEntity.isDoNotUpdate((ContextView)ctx);
        if (instance != null) {
            if (instance instanceof Collection) {
                this.applyCreator(auth, context, (Collection<?>)instance, type != MappingEventTypes.update_before, applyUpdate);
            } else {
                this.applyCreator(auth, context, (Object)instance, type != MappingEventTypes.update_before, applyUpdate);
            }
        }
        context.get(MappingContextKeys.updateColumnInstance).ifPresent(map -> this.applyCreator(auth, context, map, type != MappingEventTypes.update_before, applyUpdate));
    }

    public void applyCreator(Authentication auth, EventContext context, Object entity, boolean updateCreator, boolean updateModifier) {
        Map map;
        RecordCreationEntity e;
        long now = System.currentTimeMillis();
        if (updateCreator) {
            if (entity instanceof RecordCreationEntity) {
                e = (RecordCreationEntity)entity;
                if (ObjectUtils.isEmpty((Object)e.getCreatorId())) {
                    e.setCreatorId(auth.getUser().getId());
                    e.setCreatorName(auth.getUser().getName());
                }
                if (e.getCreateTime() == null) {
                    e.setCreateTime(Long.valueOf(now));
                }
            } else if (entity instanceof Map) {
                map = (Map)entity;
                map.putIfAbsent("creator_id", auth.getUser().getId());
                map.putIfAbsent("creator_name", auth.getUser().getName());
                map.putIfAbsent("create_time", now);
            }
        }
        if (updateModifier) {
            if (entity instanceof RecordModifierEntity) {
                e = (RecordModifierEntity)entity;
                if (ObjectUtils.isEmpty((Object)e.getModifierId())) {
                    e.setModifierId(auth.getUser().getId());
                    e.setModifierName(auth.getUser().getName());
                }
                if (e.getModifyTime() == null) {
                    e.setModifyTime(Long.valueOf(now));
                }
            } else if (entity instanceof Map) {
                map = (Map)entity;
                map.putIfAbsent("modifier_id", auth.getUser().getId());
                map.putIfAbsent("modifier_name", auth.getUser().getName());
                map.putIfAbsent("modify_time", now);
            }
        }
    }

    public void applyCreator(Authentication auth, EventContext context, Collection<?> entities, boolean updateCreator, boolean updateModifier) {
        for (Object entity : entities) {
            this.applyCreator(auth, context, entity, updateCreator, updateModifier);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

