/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationManager;
import org.hswebframework.web.authorization.ReactiveAuthenticationSupplier;
import org.hswebframework.web.authorization.token.AuthenticationUserToken;
import org.hswebframework.web.authorization.token.ParsedToken;
import org.hswebframework.web.authorization.token.ThirdPartReactiveAuthenticationManager;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.core.publisher.Mono;

public class UserTokenReactiveAuthenticationSupplier
implements ReactiveAuthenticationSupplier {
    private final ReactiveAuthenticationManager defaultAuthenticationManager;
    private final UserTokenManager userTokenManager;
    private final Map<String, ThirdPartReactiveAuthenticationManager> thirdPartAuthenticationManager = new HashMap<String, ThirdPartReactiveAuthenticationManager>();

    public UserTokenReactiveAuthenticationSupplier(UserTokenManager userTokenManager, ReactiveAuthenticationManager defaultAuthenticationManager) {
        this.defaultAuthenticationManager = defaultAuthenticationManager;
        this.userTokenManager = userTokenManager;
    }

    @Autowired(required=false)
    public void setThirdPartAuthenticationManager(List<ThirdPartReactiveAuthenticationManager> thirdPartReactiveAuthenticationManager) {
        for (ThirdPartReactiveAuthenticationManager manager : thirdPartReactiveAuthenticationManager) {
            this.thirdPartAuthenticationManager.put(manager.getTokenType(), manager);
        }
    }

    @Override
    public Mono<Authentication> get(String userId) {
        if (userId == null) {
            return null;
        }
        return this.get(this.defaultAuthenticationManager, userId);
    }

    protected Mono<Authentication> get(ThirdPartReactiveAuthenticationManager authenticationManager, String userId) {
        if (null == userId) {
            return null;
        }
        if (null == authenticationManager) {
            return this.defaultAuthenticationManager.getByUserId(userId);
        }
        return authenticationManager.getByUserId(userId);
    }

    protected Mono<Authentication> get(ReactiveAuthenticationManager authenticationManager, String userId) {
        if (null == userId) {
            return null;
        }
        if (null == authenticationManager) {
            authenticationManager = this.defaultAuthenticationManager;
        }
        return authenticationManager.getByUserId(userId);
    }

    @Override
    public Mono<Authentication> get() {
        return Mono.deferContextual(context -> context.getOrEmpty(ParsedToken.class).map(t -> this.userTokenManager.getByToken(t.getToken()).flatMap(token -> {
            if (token.isExpired()) {
                return Mono.empty();
            }
            if (!token.validate()) {
                return Mono.empty();
            }
            Mono<Void> before = this.userTokenManager.touch(token.getToken());
            if (token instanceof AuthenticationUserToken) {
                return before.thenReturn((Object)((AuthenticationUserToken)token).getAuthentication());
            }
            return before.then(this.get(this.thirdPartAuthenticationManager.get(token.getType()), token.getUserId()));
        })).orElse(Mono.empty()));
    }
}

