/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token;

import java.util.function.BiConsumer;
import org.hswebframework.web.authorization.token.SimpleParsedToken;
import org.springframework.http.HttpHeaders;

public interface ParsedToken {
    public String getToken();

    public String getType();

    default public void apply(HttpHeaders headers) {
        throw new UnsupportedOperationException("unsupported apply " + this.getType() + " token to headers");
    }

    public static ParsedToken ofBearer(String token) {
        return SimpleParsedToken.of("bearer", token, HttpHeaders::setBearerAuth);
    }

    public static ParsedToken of(String type, String token) {
        return ParsedToken.of(type, token, (_header, _token) -> _header.set("Authorization", type + " " + _token));
    }

    public static ParsedToken of(String type, String token, BiConsumer<HttpHeaders, String> headerSetter) {
        return SimpleParsedToken.of(type, token, headerSetter);
    }
}

