/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.token;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.token.AllopatricLoginMode;
import org.hswebframework.web.authorization.token.AuthenticationUserToken;
import org.hswebframework.web.authorization.token.LocalAuthenticationUserToken;
import org.hswebframework.web.authorization.token.LocalUserToken;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.authorization.token.event.UserTokenChangedEvent;
import org.hswebframework.web.authorization.token.event.UserTokenCreatedEvent;
import org.hswebframework.web.authorization.token.event.UserTokenRemovedEvent;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultUserTokenManager
implements UserTokenManager {
    protected final ConcurrentMap<String, LocalUserToken> tokenStorage;
    protected final ConcurrentMap<String, Set<String>> userStorage;
    private Map<String, AllopatricLoginMode> allopatricLoginModes = new HashMap<String, AllopatricLoginMode>();
    private AllopatricLoginMode allopatricLoginMode = AllopatricLoginMode.allow;
    private ApplicationEventPublisher eventPublisher;

    public DefaultUserTokenManager() {
        this(new ConcurrentHashMap<String, LocalUserToken>(256));
    }

    public DefaultUserTokenManager(ConcurrentMap<String, LocalUserToken> tokenStorage) {
        this(tokenStorage, new ConcurrentHashMap<String, Set<String>>());
    }

    public DefaultUserTokenManager(ConcurrentMap<String, LocalUserToken> tokenStorage, ConcurrentMap<String, Set<String>> userStorage) {
        this.tokenStorage = tokenStorage;
        this.userStorage = userStorage;
    }

    @Autowired(required=false)
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setAllopatricLoginMode(AllopatricLoginMode allopatricLoginMode) {
        this.allopatricLoginMode = allopatricLoginMode;
    }

    public AllopatricLoginMode getAllopatricLoginMode() {
        return this.allopatricLoginMode;
    }

    protected Set<String> getUserToken(String userId) {
        return this.userStorage.computeIfAbsent(userId, key -> new HashSet());
    }

    private Mono<UserToken> checkTimeout(UserToken detail) {
        if (null == detail) {
            return Mono.empty();
        }
        if (detail.getMaxInactiveInterval() <= 0L) {
            return Mono.just((Object)detail);
        }
        if (System.currentTimeMillis() - detail.getLastRequestTime() > detail.getMaxInactiveInterval()) {
            return this.changeTokenState(detail, TokenState.expired).thenReturn((Object)detail);
        }
        return Mono.just((Object)detail);
    }

    @Override
    public Mono<UserToken> getByToken(String token) {
        if (token == null) {
            return Mono.empty();
        }
        return this.checkTimeout((UserToken)this.tokenStorage.get(token));
    }

    @Override
    public Flux<UserToken> getByUserId(String userId) {
        if (userId == null) {
            return Flux.empty();
        }
        Set<String> tokens = this.getUserToken(userId);
        if (tokens.isEmpty()) {
            this.userStorage.remove(userId);
            return Flux.empty();
        }
        return Flux.fromStream(tokens.stream().map(this.tokenStorage::get).filter(Objects::nonNull));
    }

    @Override
    public Mono<Boolean> userIsLoggedIn(String userId) {
        if (userId == null) {
            return Mono.just((Object)false);
        }
        return this.getByUserId(userId).any(UserToken::isNormal);
    }

    @Override
    public Mono<Boolean> tokenIsLoggedIn(String token) {
        if (token == null) {
            return Mono.just((Object)false);
        }
        return this.getByToken(token).map(UserToken::isNormal).defaultIfEmpty((Object)false);
    }

    @Override
    public Mono<Integer> totalUser() {
        return Mono.just((Object)this.userStorage.size());
    }

    @Override
    public Mono<Integer> totalToken() {
        return Mono.just((Object)this.tokenStorage.size());
    }

    @Override
    public Flux<UserToken> allLoggedUser() {
        return Flux.fromIterable(this.tokenStorage.values());
    }

    @Override
    public Mono<Void> signOutByUserId(String userId) {
        if (null == userId) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            Set<String> tokens = this.getUserToken(userId);
            return Flux.fromIterable(tokens).flatMap(token -> this.signOutByToken((String)token, false)).then(Mono.fromRunnable(() -> {
                tokens.clear();
                this.userStorage.remove(userId);
            }));
        });
    }

    private Mono<Void> signOutByToken(String token, boolean removeUserToken) {
        LocalUserToken tokenObject;
        if (token != null && (tokenObject = (LocalUserToken)this.tokenStorage.remove(token)) != null) {
            String userId = tokenObject.getUserId();
            if (removeUserToken) {
                Set<String> tokens = this.getUserToken(userId);
                if (!tokens.isEmpty()) {
                    tokens.remove(token);
                }
                if (tokens.isEmpty()) {
                    this.userStorage.remove(tokenObject.getUserId());
                }
            }
            return new UserTokenRemovedEvent(tokenObject).publish(this.eventPublisher);
        }
        return Mono.empty();
    }

    @Override
    public Mono<Void> signOutByToken(String token) {
        return this.signOutByToken(token, true);
    }

    public Mono<Void> changeTokenState(UserToken userToken, TokenState state) {
        if (null != userToken) {
            LocalUserToken token = (LocalUserToken)userToken;
            LocalUserToken copy = token.copy();
            token.setState(state);
            this.syncToken(userToken);
            return new UserTokenChangedEvent(copy, userToken).publish(this.eventPublisher);
        }
        return Mono.empty();
    }

    @Override
    public Mono<Void> changeTokenState(String token, TokenState state) {
        return this.getByToken(token).flatMap(t -> this.changeTokenState((UserToken)t, state));
    }

    @Override
    public Mono<Void> changeUserState(String user, TokenState state) {
        return Mono.from((Publisher)this.getByUserId(user).flatMap(token -> this.changeTokenState(token.getToken(), state)));
    }

    @Override
    public Mono<UserToken> signIn(String token, String type, String userId, long maxInactiveInterval) {
        return this.doSignIn(token, type, userId, maxInactiveInterval, LocalUserToken::new).cast(UserToken.class);
    }

    private <T extends LocalUserToken> Mono<T> doSignIn(String token, String type, String userId, long maxInactiveInterval, Supplier<T> tokenSupplier) {
        return Mono.defer(() -> {
            LocalUserToken detail = (LocalUserToken)tokenSupplier.get();
            detail.setUserId(userId);
            detail.setToken(token);
            detail.setType(type);
            detail.setMaxInactiveInterval(maxInactiveInterval);
            detail.setState(TokenState.normal);
            Mono doSign = Mono.defer(() -> {
                this.tokenStorage.put(token, detail);
                this.getUserToken(userId).add(token);
                return new UserTokenCreatedEvent(detail).publish(this.eventPublisher);
            });
            AllopatricLoginMode mode = this.allopatricLoginModes.getOrDefault(type, this.allopatricLoginMode);
            if (mode == AllopatricLoginMode.deny) {
                return this.getByUserId(userId).filter(userToken -> type.equals(userToken.getType())).flatMap(this::checkTimeout).filterWhen(t -> {
                    if (t.isNormal()) {
                        return Mono.error((Throwable)((Object)new AccessDenyException("error.logged_in_elsewhere")));
                    }
                    return Mono.empty();
                }).then(doSign).thenReturn((Object)detail);
            }
            if (mode == AllopatricLoginMode.offlineOther) {
                return this.getByUserId(userId).filter(userToken -> type.equals(userToken.getType())).flatMap(userToken -> this.changeTokenState((UserToken)userToken, TokenState.offline)).then(doSign).thenReturn((Object)detail);
            }
            return doSign.thenReturn((Object)detail);
        });
    }

    @Override
    public Mono<AuthenticationUserToken> signIn(String token, String type, String userId, long maxInactiveInterval, Authentication authentication) {
        return this.doSignIn(token, type, userId, maxInactiveInterval, () -> new LocalAuthenticationUserToken(authentication)).cast(AuthenticationUserToken.class);
    }

    @Override
    public Mono<Void> touch(String token) {
        LocalUserToken userToken = (LocalUserToken)this.tokenStorage.get(token);
        if (null != userToken) {
            userToken.touch();
            this.syncToken(userToken);
        }
        return Mono.empty();
    }

    @Override
    public Mono<Void> checkExpiredToken() {
        return Flux.fromIterable(this.tokenStorage.values()).doOnNext(this::checkTimeout).filter(UserToken::isExpired).map(UserToken::getToken).flatMap(this::signOutByToken).then();
    }

    protected void syncToken(UserToken userToken) {
    }

    public Map<String, AllopatricLoginMode> getAllopatricLoginModes() {
        return this.allopatricLoginModes;
    }

    public void setAllopatricLoginModes(Map<String, AllopatricLoginMode> allopatricLoginModes) {
        this.allopatricLoginModes = allopatricLoginModes;
    }
}

