/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.simple;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.access.DataAccessConfig;

public class SimplePermission
implements Permission {
    private static final long serialVersionUID = 7587266693680162184L;
    private String id;
    private String name;
    private Set<String> actions;
    private Set<DataAccessConfig> dataAccesses;
    private Map<String, Object> options;

    @Override
    public Set<String> getActions() {
        if (this.actions == null) {
            this.actions = new HashSet<String>();
        }
        return this.actions;
    }

    @Override
    public Set<DataAccessConfig> getDataAccesses() {
        if (this.dataAccesses == null) {
            this.dataAccesses = new HashSet<DataAccessConfig>();
        }
        return this.dataAccesses;
    }

    @Override
    public Permission copy(Predicate<String> actionFilter, Predicate<DataAccessConfig> dataAccessFilter) {
        SimplePermission permission = new SimplePermission();
        permission.setId(this.id);
        permission.setName(this.name);
        permission.setActions(this.getActions().stream().filter(actionFilter).collect(Collectors.toSet()));
        permission.setDataAccesses(this.getDataAccesses().stream().filter(dataAccessFilter).collect(Collectors.toSet()));
        if (this.options != null) {
            permission.setOptions(new HashMap<String, Object>(this.options));
        }
        return permission;
    }

    @Override
    public Permission copy() {
        return this.copy(action -> true, conf -> true);
    }

    public String toString() {
        return this.id + (CollectionUtils.isNotEmpty(this.actions) ? ":" + String.join((CharSequence)",", this.actions) : "");
    }

    public static SimplePermissionBuilder builder() {
        return new SimplePermissionBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActions(Set<String> actions) {
        this.actions = actions;
    }

    public void setDataAccesses(Set<DataAccessConfig> dataAccesses) {
        this.dataAccesses = dataAccesses;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public SimplePermission() {
    }

    public SimplePermission(String id, String name, Set<String> actions, Set<DataAccessConfig> dataAccesses, Map<String, Object> options) {
        this.id = id;
        this.name = name;
        this.actions = actions;
        this.dataAccesses = dataAccesses;
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePermission)) {
            return false;
        }
        SimplePermission other = (SimplePermission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set<String> this$actions = this.getActions();
        Set<String> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        Map<String, Object> this$options = this.getOptions();
        Map<String, Object> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimplePermission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set<String> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        Map<String, Object> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public static class SimplePermissionBuilder {
        private String id;
        private String name;
        private Set<String> actions;
        private Set<DataAccessConfig> dataAccesses;
        private Map<String, Object> options;

        SimplePermissionBuilder() {
        }

        public SimplePermissionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SimplePermissionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SimplePermissionBuilder actions(Set<String> actions) {
            this.actions = actions;
            return this;
        }

        public SimplePermissionBuilder dataAccesses(Set<DataAccessConfig> dataAccesses) {
            this.dataAccesses = dataAccesses;
            return this;
        }

        public SimplePermissionBuilder options(Map<String, Object> options) {
            this.options = options;
            return this;
        }

        public SimplePermission build() {
            return new SimplePermission(this.id, this.name, this.actions, this.dataAccesses, this.options);
        }

        public String toString() {
            return "SimplePermission.SimplePermissionBuilder(id=" + this.id + ", name=" + this.name + ", actions=" + this.actions + ", dataAccesses=" + this.dataAccesses + ", options=" + this.options + ")";
        }
    }
}

