/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.define;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.annotation.Logical;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.authorization.define.ResourceActionDefinition;
import org.hswebframework.web.authorization.define.ResourceDefinition;

public class ResourcesDefinition {
    private Set<ResourceDefinition> resources = new HashSet<ResourceDefinition>();
    private Logical logical = Logical.DEFAULT;
    private Phased phased = Phased.before;

    public void addResource(ResourceDefinition resource, boolean merge) {
        ResourceDefinition definition = this.getResource(resource.getId()).orElse(null);
        if (definition != null) {
            if (merge) {
                resource.getActions().stream().map(ResourceActionDefinition::copy).forEach(definition::addAction);
            } else {
                this.resources.remove(definition);
            }
        }
        this.resources.add(resource.copy());
    }

    public Optional<ResourceDefinition> getResource(String id) {
        return this.resources.stream().filter(resource -> resource.getId().equals(id)).findAny();
    }

    @JsonIgnore
    public List<ResourceDefinition> getDataAccessResources() {
        return this.resources.stream().filter(ResourceDefinition::hasDataAccessAction).collect(Collectors.toList());
    }

    public boolean hasPermission(Permission permission) {
        if (CollectionUtils.isEmpty(this.resources)) {
            return true;
        }
        return this.getResource(permission.getId()).filter(resource -> resource.hasAction(permission.getActions())).isPresent();
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public boolean hasPermission(Authentication authentication) {
        if (CollectionUtils.isEmpty(this.resources)) {
            return true;
        }
        if (this.logical == Logical.AND) {
            return this.resources.stream().allMatch(resource -> authentication.hasPermission(resource.getId(), resource.getActionIds()));
        }
        return this.resources.stream().anyMatch(resource -> authentication.hasPermission(resource.getId(), resource.getActionIds()));
    }

    public Set<ResourceDefinition> getResources() {
        return this.resources;
    }

    public Logical getLogical() {
        return this.logical;
    }

    public Phased getPhased() {
        return this.phased;
    }

    public void setResources(Set<ResourceDefinition> resources) {
        this.resources = resources;
    }

    public void setLogical(Logical logical) {
        this.logical = logical;
    }

    public void setPhased(Phased phased) {
        this.phased = phased;
    }
}

