/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.define;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.authorization.annotation.Logical;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.authorization.define.ResourceActionDefinition;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.I18nSupportUtils;
import org.hswebframework.web.i18n.MultipleI18nSupportEntity;

public class ResourceDefinition
implements MultipleI18nSupportEntity {
    private String id;
    private String name;
    private String description;
    private Set<ResourceActionDefinition> actions = new HashSet<ResourceActionDefinition>();
    private List<String> group;
    private Map<String, Map<String, String>> i18nMessages;
    @JsonIgnore
    private volatile Set<String> actionIds;
    private Logical logical = Logical.DEFAULT;
    private Phased phased = Phased.before;
    public static final List<Locale> supportLocale = new ArrayList<Locale>();
    private static final String resolvePermissionPrefix = "hswebframework.web.system.permission.";

    public static ResourceDefinition of(String id, String name) {
        ResourceDefinition definition = new ResourceDefinition();
        definition.setId(id);
        definition.setName(name);
        return definition;
    }

    public Map<String, Map<String, String>> getI18nMessages() {
        if (org.springframework.util.CollectionUtils.isEmpty(this.i18nMessages)) {
            this.i18nMessages = I18nSupportUtils.putI18nMessages((String)(resolvePermissionPrefix + this.id), (String)"name", supportLocale, null, this.i18nMessages);
        }
        return this.i18nMessages;
    }

    public ResourceDefinition copy() {
        ResourceDefinition definition = (ResourceDefinition)FastBeanCopier.copy((Object)this, ResourceDefinition::new, (String[])new String[0]);
        definition.setActions(this.actions.stream().map(ResourceActionDefinition::copy).collect(Collectors.toSet()));
        return definition;
    }

    public ResourceDefinition addAction(String id, String name) {
        ResourceActionDefinition action = new ResourceActionDefinition();
        action.setId(id);
        action.setName(name);
        return this.addAction(action);
    }

    public synchronized ResourceDefinition addAction(ResourceActionDefinition action) {
        this.actionIds = null;
        ResourceActionDefinition old = this.getAction(action.getId()).orElse(null);
        if (old != null) {
            old.getDataAccess().getDataAccessTypes().addAll(action.getDataAccess().getDataAccessTypes());
        }
        this.actions.add(action);
        return this;
    }

    public Optional<ResourceActionDefinition> getAction(String action) {
        return this.actions.stream().filter(act -> act.getId().equalsIgnoreCase(action)).findAny();
    }

    public Set<String> getActionIds() {
        if (this.actionIds == null) {
            this.actionIds = this.actions.stream().map(ResourceActionDefinition::getId).collect(Collectors.toSet());
        }
        return this.actionIds;
    }

    @JsonIgnore
    public List<ResourceActionDefinition> getDataAccessAction() {
        return this.actions.stream().filter(act -> CollectionUtils.isNotEmpty(act.getDataAccess().getDataAccessTypes())).collect(Collectors.toList());
    }

    public boolean hasDataAccessAction() {
        return this.actions.stream().anyMatch(act -> CollectionUtils.isNotEmpty(act.getDataAccess().getDataAccessTypes()));
    }

    public boolean hasAction(Collection<String> actions) {
        if (CollectionUtils.isEmpty(this.actions)) {
            return true;
        }
        if (CollectionUtils.isEmpty(actions)) {
            return false;
        }
        if (this.logical == Logical.AND) {
            return this.getActionIds().containsAll(actions);
        }
        return this.getActionIds().stream().anyMatch(actions::contains);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<ResourceActionDefinition> getActions() {
        return this.actions;
    }

    public List<String> getGroup() {
        return this.group;
    }

    public Logical getLogical() {
        return this.logical;
    }

    public Phased getPhased() {
        return this.phased;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setActions(Set<ResourceActionDefinition> actions) {
        this.actions = actions;
    }

    public void setGroup(List<String> group) {
        this.group = group;
    }

    public void setI18nMessages(Map<String, Map<String, String>> i18nMessages) {
        this.i18nMessages = i18nMessages;
    }

    public void setLogical(Logical logical) {
        this.logical = logical;
    }

    public void setPhased(Phased phased) {
        this.phased = phased;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceDefinition)) {
            return false;
        }
        ResourceDefinition other = (ResourceDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @JsonIgnore
    private void setActionIds(Set<String> actionIds) {
        this.actionIds = actionIds;
    }

    static {
        supportLocale.add(Locale.CHINESE);
        supportLocale.add(Locale.ENGLISH);
    }
}

