/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.define;

import java.util.List;
import java.util.Set;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizeDefinitionContext;
import org.hswebframework.web.authorization.define.DimensionDefinition;
import org.hswebframework.web.authorization.define.DimensionsDefinition;
import org.hswebframework.web.authorization.define.ResourceDefinition;
import org.hswebframework.web.authorization.define.ResourcesDefinition;

public class MergedAuthorizeDefinition
implements AuthorizeDefinitionContext {
    private final ResourcesDefinition resources = new ResourcesDefinition();
    private final DimensionsDefinition dimensions = new DimensionsDefinition();

    public Set<ResourceDefinition> getResources() {
        return this.resources.getResources();
    }

    public Set<DimensionDefinition> getDimensions() {
        return this.dimensions.getDimensions();
    }

    @Override
    public void addResource(ResourceDefinition resource) {
        this.resources.addResource(resource, true);
    }

    public void addDimension(DimensionDefinition resource) {
        this.dimensions.addDimension(resource);
    }

    public void merge(List<AuthorizeDefinition> definitions) {
        for (AuthorizeDefinition definition : definitions) {
            definition.getResources().getResources().forEach(this::addResource);
            definition.getDimensions().getDimensions().forEach(this::addDimension);
        }
    }
}

