/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationSupplier;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactiveAuthenticationHolder {
    private static final List<ReactiveAuthenticationSupplier> suppliers = new CopyOnWriteArrayList<ReactiveAuthenticationSupplier>();

    private static Mono<Authentication> get(Function<ReactiveAuthenticationSupplier, Mono<Authentication>> function) {
        return Flux.merge((Iterable)Lists.transform(suppliers, function::apply)).collect(AuthenticationMerging::new, AuthenticationMerging::merge).mapNotNull(rec$ -> ((AuthenticationMerging)rec$).get());
    }

    public static Mono<Authentication> get() {
        return ReactiveAuthenticationHolder.get(Supplier::get);
    }

    public static Mono<Authentication> get(String userId) {
        return ReactiveAuthenticationHolder.get((ReactiveAuthenticationSupplier supplier) -> supplier.get(userId));
    }

    public static void addSupplier(ReactiveAuthenticationSupplier supplier) {
        suppliers.add(supplier);
    }

    public static void setSupplier(ReactiveAuthenticationSupplier supplier) {
        suppliers.clear();
        suppliers.add(supplier);
    }

    static class AuthenticationMerging {
        private Authentication auth;
        private int count;

        AuthenticationMerging() {
        }

        public synchronized void merge(Authentication auth) {
            if (this.auth == null || this.auth == auth) {
                this.auth = auth;
            } else {
                if (this.count++ == 0) {
                    SimpleAuthentication newAuth = new SimpleAuthentication();
                    newAuth.merge(this.auth);
                    this.auth = newAuth;
                }
                this.auth.merge(auth);
            }
        }

        private Authentication get() {
            return this.auth;
        }
    }
}

