/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.AuthenticationHolder;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.authorization.Permission;
import org.hswebframework.web.authorization.ReactiveAuthenticationHolder;
import org.hswebframework.web.authorization.User;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public interface Authentication
extends Serializable {
    public static Mono<Authentication> currentReactive() {
        return ReactiveAuthenticationHolder.get();
    }

    public static Optional<Authentication> current() {
        return AuthenticationHolder.get();
    }

    public User getUser();

    public List<Dimension> getDimensions();

    public List<Permission> getPermissions();

    default public boolean hasDimension(String type, String ... id) {
        return this.hasDimension(type, Arrays.asList(id));
    }

    default public boolean hasDimension(String type, Collection<String> id) {
        if (id.isEmpty()) {
            return !this.getDimensions(type).isEmpty();
        }
        return this.getDimensions(type).stream().anyMatch(p -> id.contains(p.getId()));
    }

    default public boolean hasDimension(DimensionType type, String id) {
        return this.getDimension(type, id).isPresent();
    }

    default public Optional<Dimension> getDimension(String type, String id) {
        if (!StringUtils.hasText((String)type)) {
            return Optional.empty();
        }
        return this.getDimensions().stream().filter(dimension -> dimension.getId().equals(id) && type.equalsIgnoreCase(dimension.getType().getId())).findFirst();
    }

    default public Optional<Dimension> getDimension(DimensionType type, String id) {
        if (type == null) {
            return Optional.empty();
        }
        return this.getDimensions().stream().filter(dimension -> dimension.getId().equals(id) && type.isSameType(dimension.getType())).findFirst();
    }

    default public List<Dimension> getDimensions(String type) {
        if (!StringUtils.hasText((String)type)) {
            return Collections.emptyList();
        }
        return this.getDimensions().stream().filter(dimension -> dimension.getType().isSameType(type)).collect(Collectors.toList());
    }

    default public List<Dimension> getDimensions(DimensionType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        return this.getDimensions().stream().filter(dimension -> dimension.getType().isSameType(type)).collect(Collectors.toList());
    }

    default public Optional<Permission> getPermission(String id) {
        if (null == id) {
            return Optional.empty();
        }
        return this.getPermissions().stream().filter(permission -> permission.getId().equals(id)).findAny();
    }

    default public boolean hasPermission(String permissionId, String ... actions) {
        return this.hasPermission(permissionId, actions.length == 0 ? Collections.emptyList() : Arrays.asList(actions));
    }

    default public boolean hasPermission(String permissionId, Collection<String> actions) {
        for (Permission permission : this.getPermissions()) {
            if (Objects.equals(permission.getId(), "*")) {
                return true;
            }
            if (!Objects.equals(permissionId, permission.getId())) continue;
            return actions.isEmpty() || permission.getActions().containsAll(actions) || permission.getActions().contains("*");
        }
        return false;
    }

    public <T extends Serializable> Optional<T> getAttribute(String var1);

    public Map<String, Serializable> getAttributes();

    default public void setAttribute(String key, Serializable value) {
        this.getAttributes().put(key, value);
    }

    public Authentication merge(Authentication var1);

    public Authentication copy(BiPredicate<Permission, String> var1, Predicate<Dimension> var2);
}

