/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.io.TruffleProcessBuilder;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.builtins.GlobalBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.commonjs.GlobalCommonJSRequireBuiltins;
import com.oracle.truffle.js.builtins.helper.FloatParser;
import com.oracle.truffle.js.builtins.helper.StringEscape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import com.oracle.truffle.js.nodes.function.EvalNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSLoadNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.ExitException;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSConsoleUtil;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSURLDecoder;
import com.oracle.truffle.js.runtime.builtins.JSURLEncoder;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import com.oracle.truffle.js.runtime.util.BufferUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.util.EnumSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.script.Bindings;

public class GlobalBuiltins
extends JSBuiltinsContainer.SwitchEnum<Global> {
    public static final JSBuiltinsContainer GLOBAL_FUNCTIONS = new GlobalBuiltins();
    public static final JSBuiltinsContainer GLOBAL_SHELL = new GlobalShellBuiltins();
    public static final JSBuiltinsContainer GLOBAL_NASHORN_EXTENSIONS = new GlobalNashornScriptingBuiltins();
    public static final JSBuiltinsContainer GLOBAL_PRINT = new GlobalPrintBuiltins();
    public static final JSBuiltinsContainer GLOBAL_LOAD = new GlobalLoadBuiltins();
    public static final JSBuiltinsContainer GLOBAL_COMMONJS_REQUIRE_EXTENSIONS = new GlobalCommonJSRequireBuiltins();

    protected GlobalBuiltins() {
        super(Global.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, Global builtinEnum) {
        switch (builtinEnum) {
            case isNaN: {
                return GlobalBuiltinsFactory.JSGlobalIsNaNNodeGen.create(context, builtin, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case isFinite: {
                return GlobalBuiltinsFactory.JSGlobalIsFiniteNodeGen.create(context, builtin, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case parseFloat: {
                return GlobalBuiltinsFactory.JSGlobalParseFloatNodeGen.create(context, builtin, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case parseInt: {
                return GlobalBuiltinsFactory.JSGlobalParseIntNodeGen.create(context, builtin, GlobalBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case encodeURI: {
                return GlobalBuiltinsFactory.JSGlobalEncodeURINodeGen.create(context, builtin, true, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case encodeURIComponent: {
                return GlobalBuiltinsFactory.JSGlobalEncodeURINodeGen.create(context, builtin, false, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case decodeURI: {
                return GlobalBuiltinsFactory.JSGlobalDecodeURINodeGen.create(context, builtin, true, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case decodeURIComponent: {
                return GlobalBuiltinsFactory.JSGlobalDecodeURINodeGen.create(context, builtin, false, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case eval: {
                return GlobalBuiltinsFactory.JSGlobalIndirectEvalNodeGen.create(context, builtin, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case escape: {
                return GlobalBuiltinsFactory.JSGlobalUnEscapeNodeGen.create(context, builtin, false, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case unescape: {
                return GlobalBuiltinsFactory.JSGlobalUnEscapeNodeGen.create(context, builtin, true, GlobalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static TruffleFile resolveRelativeFilePath(String path, TruffleLanguage.Env env) {
        TruffleFile f;
        CompilerAsserts.neverPartOfCompilation();
        TruffleFile file = env.getPublicTruffleFile(path);
        if (!file.isAbsolute() && !file.exists(new LinkOption[0]) && (f = GlobalBuiltins.tryResolveCallerRelativeFilePath(path, env)) != null) {
            return f;
        }
        return file;
    }

    private static TruffleFile tryResolveCallerRelativeFilePath(String path, TruffleLanguage.Env env) {
        TruffleFile file;
        TruffleFile callerFile;
        String callerPath;
        SourceSection callerSourceSection;
        CompilerAsserts.neverPartOfCompilation();
        CallTarget caller = Truffle.getRuntime().getCallerFrame().getCallTarget();
        if (caller instanceof RootCallTarget && (callerSourceSection = ((RootCallTarget)caller).getRootNode().getSourceSection()) != null && callerSourceSection.isAvailable() && (callerPath = callerSourceSection.getSource().getPath()) != null && (callerFile = env.getPublicTruffleFile(callerPath)).isAbsolute() && (file = callerFile.resolveSibling(path).normalize()).isRegularFile(new LinkOption[0])) {
            return file;
        }
        return null;
    }

    static TruffleFile getFileFromArgument(Object arg, TruffleLanguage.Env env) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            String path = JSRuntime.isString(arg) ? arg.toString() : (env.isHostObject(arg) && env.asHostObject(arg) instanceof File ? ((File)env.asHostObject(arg)).getPath() : JSRuntime.toString(arg));
            TruffleFile file = GlobalBuiltins.resolveRelativeFilePath(path, env);
            if (!file.isRegularFile(new LinkOption[0])) {
                throw Errors.createNotAFileError(path);
            }
            return file;
        }
        catch (SecurityException e) {
            throw Errors.createErrorFromException(e);
        }
    }

    static abstract class JSGlobalImportScriptEngineGlobalBindingsNode
    extends JSBuiltinNode {
        JSGlobalImportScriptEngineGlobalBindingsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        final Object importGlobalContext(Object globalContextBindings) {
            this.doImport(globalContextBindings);
            return Undefined.instance;
        }

        @CompilerDirectives.TruffleBoundary
        private void doImport(Object globalContextBindings) {
            DynamicObject globalObject = this.getContext().getRealm().getGlobalObject();
            Bindings bindings = (Bindings)this.getContext().getRealm().getEnv().asHostObject(globalContextBindings);
            for (Map.Entry entry : bindings.entrySet()) {
                String key = (String)entry.getKey();
                if (globalObject.getShape().hasProperty((Object)key) || JSObject.getPrototype(globalObject).getShape().hasProperty((Object)key)) continue;
                JSObjectUtil.defineProxyProperty(globalObject, key, new ScriptEngineGlobalScopeBindingsPropertyProxy(this.getContext(), bindings, key), JSAttributes.getDefault());
            }
        }

        private static class ScriptEngineGlobalScopeBindingsPropertyProxy
        implements PropertyProxy {
            private final JSContext context;
            private final Bindings globalContextBindings;
            private final String key;

            ScriptEngineGlobalScopeBindingsPropertyProxy(JSContext context, Bindings globalContextBindings, String key) {
                this.context = context;
                this.globalContextBindings = globalContextBindings;
                this.key = key;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object get(DynamicObject store) {
                Object value = this.globalContextBindings.get(this.key);
                if (value == null) {
                    return Undefined.instance;
                }
                return JSRuntime.importValue(this.context.getRealm().getEnv().asGuestValue(value));
            }

            @Override
            public boolean set(DynamicObject store, Object value) {
                JSObjectUtil.defineDataProperty(store, this.key, value, JSAttributes.getDefault());
                return true;
            }
        }
    }

    public static abstract class JSGlobalReadBufferNode
    extends JSBuiltinNode {
        public JSGlobalReadBufferNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Specialization
        protected final DynamicObject readbuffer(Object fileParam) {
            TruffleFile file = GlobalBuiltins.getFileFromArgument(fileParam, this.getContext().getRealm().getEnv());
            try {
                DynamicObject arrayBuffer;
                byte[] bytes = file.readAllBytes();
                if (this.getContext().isOptionDirectByteBuffer()) {
                    ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
                    buffer.put(bytes);
                    BufferUtil.asBaseBuffer(buffer).rewind();
                    arrayBuffer = JSArrayBuffer.createDirectArrayBuffer(this.getContext(), buffer);
                } else {
                    arrayBuffer = JSArrayBuffer.createArrayBuffer(this.getContext(), bytes);
                }
                return arrayBuffer;
            }
            catch (Exception ex) {
                throw Errors.createErrorFromException(ex);
            }
        }
    }

    public static abstract class JSGlobalReadFullyNode
    extends JSBuiltinNode {
        private static final int BUFFER_SIZE = 2048;

        public JSGlobalReadFullyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Specialization
        protected String read(Object fileParam) {
            TruffleFile file = GlobalBuiltins.getFileFromArgument(fileParam, this.getContext().getRealm().getEnv());
            try {
                return JSGlobalReadFullyNode.readImpl(file.newBufferedReader());
            }
            catch (Exception ex) {
                throw Errors.createErrorFromException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String readImpl(BufferedReader reader) throws IOException {
            StringBuilder sb = new StringBuilder();
            char[] arr = new char[2048];
            try {
                int numChars;
                while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                    sb.append(arr, 0, numChars);
                }
            }
            finally {
                reader.close();
            }
            return sb.toString();
        }
    }

    public static abstract class JSGlobalReadLineNode
    extends JSGlobalOperation {
        public JSGlobalReadLineNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected String readLine(Object prompt) {
            String promptString = null;
            if (prompt != Undefined.instance) {
                promptString = this.toString1(prompt);
            }
            return this.doReadLine(promptString);
        }

        @CompilerDirectives.TruffleBoundary
        private String doReadLine(String promptString) {
            if (promptString != null) {
                this.getContext().getRealm().getOutputWriter().print(promptString);
            }
            try {
                BufferedReader inReader = new BufferedReader(new InputStreamReader(this.getContext().getRealm().getEnv().in()));
                return inReader.readLine();
            }
            catch (Exception ex) {
                throw Errors.createError(ex.getMessage());
            }
        }
    }

    public static abstract class JSGlobalExitNode
    extends JSBuiltinNode {
        public JSGlobalExitNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object exit(Object[] arg, @Cached(value="create()") JSToNumberNode toNumberNode) {
            int exitCode;
            int n = exitCode = arg.length == 0 ? 0 : (int)JSRuntime.toInteger(toNumberNode.executeNumber(arg[0]));
            if (this.getContext().isOptionNashornCompatibilityMode()) {
                JSGlobalExitNode.nashornExit(exitCode);
            }
            throw new ExitException(exitCode, this);
        }

        @CompilerDirectives.TruffleBoundary
        private static void nashornExit(int exitCode) {
            System.exit(exitCode);
        }
    }

    public static abstract class JSGlobalLoadWithNewGlobalNode
    extends JSGlobalLoadNode {
        public JSGlobalLoadWithNewGlobalNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        protected Object evalImpl(JSRealm realm, String fileName, String source, Object[] args) {
            JSRealm childRealm = realm.createChildRealm();
            DynamicObject argObj = JSArgumentsObject.createStrict(this.getContext(), childRealm, args);
            JSRuntime.createDataProperty(childRealm.getGlobalObject(), "arguments", argObj);
            return JSGlobalLoadWithNewGlobalNode.loadStringImpl(this.getContext(), fileName, source).run(childRealm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object loadFromPath(String path, JSRealm realm, Object[] args) {
            JSRealm childRealm = realm.createChildRealm();
            TruffleContext childContext = childRealm.getTruffleContext();
            Object prev = childContext.enter();
            try {
                DynamicObject argObj = JSArgumentsObject.createStrict(this.getContext(), childRealm, args);
                JSRuntime.createDataProperty(childRealm.getGlobalObject(), "arguments", argObj);
                Source source = this.sourceFromPath(path, childRealm);
                Object object = this.runImpl(childRealm, source);
                return object;
            }
            finally {
                childContext.leave(prev);
            }
        }
    }

    @ImportStatic(value={JSInteropUtil.class})
    public static abstract class JSGlobalLoadNode
    extends JSLoadOperation {
        public JSGlobalLoadNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object loadString(String path, Object[] args) {
            JSRealm realm = this.getContext().getRealm();
            return this.loadFromPath(path, realm, args);
        }

        protected Object loadFromPath(String path, JSRealm realm, Object[] args) {
            Source source = this.sourceFromPath(path, realm);
            return this.runImpl(realm, source);
        }

        @Specialization(guards={"isForeignObject(scriptObj)"})
        protected Object loadTruffleObject(Object scriptObj, Object[] args, @CachedLibrary(limit="3") InteropLibrary interop) {
            Object unboxed;
            JSRealm realm = this.getContext().getRealm();
            TruffleLanguage.Env env = realm.getEnv();
            if (env.isHostObject(scriptObj)) {
                Object hostObject = env.asHostObject(scriptObj);
                if (hostObject instanceof File) {
                    return this.loadFile(realm, (File)hostObject);
                }
                if (this.getContext().isOptionNashornCompatibilityMode() && hostObject instanceof URL) {
                    return this.loadURL(realm, (URL)hostObject);
                }
            }
            if ((unboxed = JSInteropUtil.toPrimitiveOrDefault(scriptObj, Null.instance, interop, this)) == Null.instance) {
                throw JSGlobalLoadNode.cannotLoadScript(scriptObj);
            }
            String stringPath = this.toString1(unboxed);
            return this.loadFromPath(stringPath, realm, args);
        }

        @Specialization(guards={"isJSObject(scriptObj)"})
        protected Object loadScriptObj(DynamicObject scriptObj, Object[] args, @Cached(value="create()") JSToStringNode sourceToStringNode) {
            JSRealm realm = this.getContext().getRealm();
            if (JSObject.hasProperty(scriptObj, "name") && JSObject.hasProperty(scriptObj, "script")) {
                Object scriptNameObj = JSObject.get(scriptObj, (Object)"name");
                Object sourceObj = JSObject.get(scriptObj, (Object)"script");
                return this.evalImpl(realm, this.toString1(scriptNameObj), sourceToStringNode.executeString(sourceObj), args);
            }
            throw JSGlobalLoadNode.cannotLoadScript(scriptObj);
        }

        @Specialization(guards={"!isString(fileName)", "!isForeignObject(fileName)", "!isJSObject(fileName)"})
        protected Object loadConvertToString(Object fileName, Object[] args) {
            return this.loadString(this.toString1(fileName), args);
        }

        protected Object loadFile(JSRealm realm, File file) {
            return this.runImpl(realm, this.sourceFromFileName(JSGlobalLoadNode.fileGetPath(file), realm));
        }

        protected Object loadURL(JSRealm realm, URL url) {
            assert (this.getContext().isOptionNashornCompatibilityMode());
            return this.runImpl(realm, this.sourceFromURL(url));
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        protected Object evalImpl(JSRealm realm, String fileName, String source, Object[] args) {
            return JSGlobalLoadNode.loadStringImpl(this.getContext(), fileName, source).run(realm);
        }
    }

    public static abstract class JSGlobalPrintNode
    extends JSGlobalOperation {
        private final ConditionProfile argumentsCount = ConditionProfile.createBinaryProfile();
        private final BranchProfile consoleIndentation = BranchProfile.create();
        private final boolean useErr;

        public JSGlobalPrintNode(JSContext context, JSBuiltin builtin, boolean useErr) {
            super(context, builtin);
            this.useErr = useErr;
        }

        public abstract Object executeObjectArray(Object[] var1);

        @Specialization
        protected Object print(Object[] arguments) {
            StringBuilder builder = new StringBuilder();
            JSConsoleUtil consoleUtil = this.getContext().getRealm().getConsoleUtil();
            if (consoleUtil.getConsoleIndentation() > 0) {
                this.consoleIndentation.enter();
                Boundaries.builderAppend(builder, consoleUtil.getConsoleIndentationString());
            }
            if (this.argumentsCount.profile(arguments.length == 1)) {
                Boundaries.builderAppend(builder, this.toString1(arguments[0]));
            } else {
                for (int i = 0; i < arguments.length; ++i) {
                    if (i != 0) {
                        Boundaries.builderAppend(builder, ' ');
                    }
                    Boundaries.builderAppend(builder, this.toString1(arguments[i]));
                }
            }
            return this.printIntl(builder);
        }

        @CompilerDirectives.TruffleBoundary
        private Object printIntl(StringBuilder builder) {
            builder.append('\n');
            JSRealm realm = this.getContext().getRealm();
            PrintWriter writer = this.useErr ? realm.getErrorWriter() : realm.getOutputWriter();
            writer.print(builder.toString());
            writer.flush();
            return Undefined.instance;
        }
    }

    public static abstract class JSGlobalUnEscapeNode
    extends JSGlobalOperation {
        private final boolean unescape;

        public JSGlobalUnEscapeNode(JSContext context, JSBuiltin builtin, boolean unescape) {
            super(context, builtin);
            this.unescape = unescape;
        }

        @Specialization
        protected String escape(Object value) {
            String s = this.toString1(value);
            return this.unescape ? StringEscape.unescape(s) : StringEscape.escape(s);
        }
    }

    public static abstract class JSGlobalIndirectEvalNode
    extends JSBuiltinNode {
        public JSGlobalIndirectEvalNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object indirectEvalString(String source) {
            JSRealm realm = this.getContext().getRealm();
            return this.indirectEvalImpl(realm, source);
        }

        @Specialization(guards={"isForeignObject(source)"}, limit="3")
        protected Object indirectEvalForeignObject(Object source, @CachedLibrary(value="source") InteropLibrary interop) {
            if (interop.isString(source)) {
                try {
                    return this.indirectEvalString(interop.asString(source));
                }
                catch (UnsupportedMessageException ex) {
                    throw Errors.createTypeErrorInteropException(source, (InteropException)((Object)ex), "asString", this);
                }
            }
            return source;
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        private Object indirectEvalImpl(JSRealm realm, String source) {
            String sourceName = null;
            if (this.isCallerSensitive()) {
                sourceName = EvalNode.findAndFormatEvalOrigin(realm.getCallNode(), realm.getContext());
            }
            if (sourceName == null) {
                sourceName = "<eval>";
            }
            return this.getContext().getEvaluator().evaluate(realm, this, Source.newBuilder((String)"js", (CharSequence)source, (String)sourceName).build());
        }

        @Specialization
        protected int indirectEvalInt(int source) {
            return source;
        }

        @Specialization
        protected SafeInteger indirectEvalSafeInteger(SafeInteger source) {
            return source;
        }

        @Specialization
        protected long indirectEvalLong(long source) {
            return source;
        }

        @Specialization
        protected double indirectEvalDouble(double source) {
            return source;
        }

        @Specialization
        protected boolean indirectEvalBoolean(boolean source) {
            return source;
        }

        @Specialization
        protected Symbol indirectEvalSymbol(Symbol source) {
            return source;
        }

        @Specialization
        protected BigInt indirectEvalBigInt(BigInt source) {
            return source;
        }

        @Specialization(guards={"isJSType(object)"})
        public DynamicObject indirectEvalJSType(DynamicObject object) {
            return object;
        }

        @Override
        public boolean isCallerSensitive() {
            return this.getContext().isOptionV8CompatibilityMode();
        }
    }

    public static abstract class JSGlobalDecodeURINode
    extends JSGlobalOperation {
        private final JSURLDecoder decoder;

        public JSGlobalDecodeURINode(JSContext context, JSBuiltin builtin, boolean isSpecial) {
            super(context, builtin);
            this.decoder = new JSURLDecoder(isSpecial);
        }

        @Specialization
        protected String decodeURI(Object value) {
            return this.decoder.decode(this.toString1(value));
        }
    }

    public static abstract class JSGlobalEncodeURINode
    extends JSGlobalOperation {
        private final JSURLEncoder encoder;

        public JSGlobalEncodeURINode(JSContext context, JSBuiltin builtin, boolean isSpecial) {
            super(context, builtin);
            this.encoder = new JSURLEncoder(isSpecial);
        }

        @Specialization
        protected String encodeURI(Object value) {
            return this.encoder.encode(this.toString1(value));
        }
    }

    public static abstract class JSGlobalParseIntNode
    extends JSBuiltinNode {
        @Node.Child
        private JSToInt32Node toInt32Node;
        private final BranchProfile needsNaN = BranchProfile.create();

        public JSGlobalParseIntNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected int toInt32(Object target) {
            if (this.toInt32Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toInt32Node = (JSToInt32Node)this.insert(JSToInt32Node.create());
            }
            return this.toInt32Node.executeInt(target);
        }

        @Specialization(guards={"isUndefined(radix0)"})
        protected int parseIntNoRadix(int thing, Object radix0) {
            return thing;
        }

        @Specialization(guards={"!isUndefined(radix0)"})
        protected Object parseInt(int thing, Object radix0, @Cached(value="create()") BranchProfile needsRadixConversion) {
            int radix = this.toInt32(radix0);
            if (radix == 10 || radix == 0) {
                return thing;
            }
            if (radix < 2 || radix > 36) {
                this.needsNaN.enter();
                return Double.NaN;
            }
            needsRadixConversion.enter();
            return JSGlobalParseIntNode.convertToRadix(thing, radix);
        }

        @Specialization(guards={"hasRegularToStringInInt32Range(thing)", "isUndefined(radix0)"})
        protected int parseIntDoubleToInt(double thing, Object radix0) {
            return (int)thing;
        }

        @Specialization(guards={"hasRegularToString(thing)", "isUndefined(radix0)"})
        protected double parseIntNoRadix(double thing, Object radix0) {
            return JSRuntime.truncateDouble2(thing);
        }

        protected static boolean hasRegularToString(double value) {
            return -1.0E21 < value && value <= -1.0E-6 || 1.0E-6 <= value && value < 1.0E21;
        }

        protected static boolean hasRegularToStringInInt32Range(double value) {
            return -2.147483649E9 < value && value <= -1.0 || value == 0.0 || 1.0E-6 <= value && value < 2.147483648E9;
        }

        @Specialization(guards={"hasRegularToString(thing)"})
        protected double parseInt(double thing, Object radix0, @Cached(value="create()") BranchProfile needsRadixConversion) {
            int radix = this.toInt32(radix0);
            if (radix == 0) {
                radix = 10;
            } else if (radix < 2 || radix > 36) {
                this.needsNaN.enter();
                return Double.NaN;
            }
            double truncated = JSRuntime.truncateDouble2(thing);
            if (radix == 10) {
                return truncated;
            }
            needsRadixConversion.enter();
            return JSGlobalParseIntNode.convertToRadix(truncated, radix);
        }

        @Specialization
        protected Object parseIntGeneric(Object thing, Object radix0, @Cached(value="create()") JSToStringNode toStringNode, @Cached(value="create()") JSTrimWhitespaceNode trimWhitespaceNode, @Cached(value="create()") BranchProfile needsRadix16, @Cached(value="create()") BranchProfile needsDontFitLong, @Cached(value="create()") BranchProfile needsTrimming) {
            String inputString = trimWhitespaceNode.executeString(toStringNode.executeString(thing));
            int radix = this.toInt32(radix0);
            if (inputString.length() <= 0) {
                this.needsNaN.enter();
                return Double.NaN;
            }
            if (radix == 16 || radix == 0) {
                needsRadix16.enter();
                if (JSGlobalParseIntNode.hasHexStart(inputString)) {
                    needsTrimming.enter();
                    if (inputString.charAt(0) == '0') {
                        inputString = Boundaries.substring(inputString, 2);
                    } else {
                        String sign = Boundaries.substring(inputString, 0, 1);
                        String number = Boundaries.substring(inputString, 3);
                        inputString = JSRuntime.stringConcat(sign, number);
                    }
                    radix = 16;
                } else if (radix == 0) {
                    radix = 10;
                }
            } else if (radix < 2 || radix > 36) {
                this.needsNaN.enter();
                return Double.NaN;
            }
            int len = JSGlobalParseIntNode.validStringLength(inputString, radix);
            if (len <= 0) {
                this.needsNaN.enter();
                return Double.NaN;
            }
            if (radix <= 10 && len >= 18 || 10 < radix && radix <= 16 && len >= 15 || radix > 16 && len >= 12) {
                needsDontFitLong.enter();
                if (radix == 10) {
                    return JSGlobalParseIntNode.parseDouble(Boundaries.substring(inputString, 0, len));
                }
                return JSRuntime.parseRawDontFitLong(inputString, radix, len);
            }
            return JSRuntime.parseRawFitsLong(inputString, radix, len);
        }

        @CompilerDirectives.TruffleBoundary
        private static double parseDouble(String s) {
            return Double.parseDouble(s);
        }

        private static Object convertToRadix(int thing, int radix) {
            assert (radix >= 2 && radix <= 36);
            boolean negative = thing < 0;
            long value = thing;
            if (negative) {
                value = -value;
            }
            long result = 0L;
            long radixVal = 1L;
            while (value != 0L) {
                long digit = value % 10L;
                if (digit >= (long)radix) {
                    return Double.NaN;
                }
                result += digit * radixVal;
                value /= 10L;
                radixVal *= (long)radix;
            }
            if (negative) {
                result = -result;
            }
            return JSRuntime.longToIntOrDouble(result);
        }

        private static double convertToRadix(double thing, int radix) {
            assert (radix >= 2 && radix <= 36);
            boolean negative = thing < 0.0;
            double value = negative ? -thing : thing;
            double result = 0.0;
            double radixVal = 1.0;
            while (value != 0.0) {
                double digit = value % 10.0;
                if (digit >= (double)radix) {
                    return Double.NaN;
                }
                result += digit * radixVal;
                value -= digit;
                value /= 10.0;
                radixVal *= (double)radix;
            }
            return negative ? -result : result;
        }

        private static boolean hasHexStart(String inputString) {
            char c0;
            int length = inputString.length();
            if (length >= 2 && inputString.charAt(0) == '0') {
                char c1 = inputString.charAt(1);
                return c1 == 'x' || c1 == 'X';
            }
            if (length >= 3 && inputString.charAt(1) == '0' && ((c0 = inputString.charAt(0)) == '-' || c0 == '+')) {
                char c2 = inputString.charAt(2);
                return c2 == 'x' || c2 == 'X';
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private static int validStringLength(String thing, int radix) {
            char c;
            boolean hasSign = false;
            int pos = 0;
            if (!(thing.isEmpty() || (c = thing.charAt(0)) != '+' && c != '-')) {
                hasSign = true;
                ++pos;
            }
            while (pos < thing.length() && JSRuntime.valueInRadix(c = thing.charAt(pos), radix) != -1) {
                ++pos;
            }
            if (pos == 1 && hasSign) {
                pos = 0;
            }
            return pos;
        }
    }

    public static abstract class JSGlobalParseFloatNode
    extends JSGlobalOperation {
        private final BranchProfile exponentBranch = BranchProfile.create();
        @Node.Child
        protected JSTrimWhitespaceNode trimWhitespaceNode;

        public JSGlobalParseFloatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int parseFloat(int value) {
            return value;
        }

        @Specialization
        protected double parseFloat(double value, @Cached(value="createBinaryProfile()") ConditionProfile negativeZero) {
            if (negativeZero.profile(JSRuntime.isNegativeZero(value))) {
                return 0.0;
            }
            return value;
        }

        @Specialization
        protected double parseFloat(boolean value) {
            return Double.NaN;
        }

        @Specialization(guards={"isUndefined(value)"})
        protected double parseFloatUndefined(Object value) {
            return Double.NaN;
        }

        @Specialization(guards={"isJSNull(value)"})
        protected double parseFloatNull(Object value) {
            return Double.NaN;
        }

        @Specialization
        protected double parseFloat(String value) {
            return this.parseFloatIntl(value);
        }

        @Specialization(guards={"!isJSNull(value)", "!isUndefined(value)"})
        protected double parseFloat(TruffleObject value) {
            return this.parseFloatIntl(this.toString1(value));
        }

        private double parseFloatIntl(String inputString) {
            String trimmedString = this.trimWhitespace(inputString);
            return this.parseFloatIntl2(trimmedString);
        }

        @CompilerDirectives.TruffleBoundary
        private double parseFloatIntl2(String trimmedString) {
            if (trimmedString.startsWith("Infinity") || trimmedString.startsWith("+Infinity")) {
                return Double.POSITIVE_INFINITY;
            }
            if (trimmedString.startsWith("-Infinity")) {
                return Double.NEGATIVE_INFINITY;
            }
            try {
                FloatParser parser = new FloatParser(trimmedString, this.exponentBranch);
                return parser.getResult();
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }

        protected String trimWhitespace(String s) {
            if (this.trimWhitespaceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.trimWhitespaceNode = (JSTrimWhitespaceNode)this.insert(JSTrimWhitespaceNode.create());
            }
            return this.trimWhitespaceNode.executeString(s);
        }
    }

    public static abstract class JSGlobalIsFiniteNode
    extends JSBuiltinNode {
        public JSGlobalIsFiniteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean isFinite(int value) {
            return true;
        }

        @Specialization
        protected static boolean isFinite(double value) {
            return !Double.isInfinite(value) && !Double.isNaN(value);
        }

        @Specialization(guards={"!isUndefined(value)"})
        protected static boolean isFinite(Object value, @Cached(value="create()") JSToDoubleNode toDoubleNode) {
            return JSGlobalIsFiniteNode.isFinite(toDoubleNode.executeDouble(value));
        }

        @Specialization(guards={"isUndefined(value)"})
        protected static boolean isFinite(Object value) {
            return false;
        }
    }

    public static abstract class JSGlobalIsNaNNode
    extends JSBuiltinNode {
        public JSGlobalIsNaNNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean isNaN(int value) {
            return false;
        }

        @Specialization
        protected static boolean isNaN(double value) {
            return Double.isNaN(value);
        }

        @Specialization(guards={"!isUndefined(value)"})
        protected static boolean isNaN(Object value, @Cached(value="create()") JSToDoubleNode toDoubleNode) {
            return JSGlobalIsNaNNode.isNaN(toDoubleNode.executeDouble(value));
        }

        @Specialization(guards={"isUndefined(value)"})
        protected static boolean isNaN(Object value) {
            return true;
        }
    }

    public static abstract class JSLoadOperation
    extends JSFileLoadingOperation {
        @Node.Child
        private JSLoadNode loadNode;
        protected static final String EVAL_OBJ_FILE_NAME = "name";
        protected static final String EVAL_OBJ_SOURCE = "script";
        private static final String LOAD_CLASSPATH = "classpath:";
        private static final String LOAD_FX = "fx:";
        private static final String LOAD_NASHORN = "nashorn:";
        private static final String RESOURCES_PATH = "resources/";
        private static final String FX_RESOURCES_PATH = "resources/fx/";
        private static final String NASHORN_BASE_PATH = "jdk/nashorn/internal/runtime/";
        private static final String NASHORN_PARSER_JS = "nashorn:parser.js";
        private static final String NASHORN_MOZILLA_COMPAT_JS = "nashorn:mozilla_compat.js";

        public JSLoadOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected final Object runImpl(JSRealm realm, Source source) {
            if (this.loadNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.loadNode = (JSLoadNode)this.insert(JSLoadNode.create(this.getContext()));
            }
            return this.loadNode.executeLoad(source, realm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static ScriptNode loadStringImpl(JSContext ctxt, String name, String script) {
            CompilerAsserts.neverPartOfCompilation();
            long startTime = ctxt.getContextOptions().isProfileTime() ? System.nanoTime() : 0L;
            try {
                ScriptNode scriptNode = ctxt.getEvaluator().evalCompile(ctxt, script, name);
                return scriptNode;
            }
            finally {
                if (ctxt.getContextOptions().isProfileTime()) {
                    ctxt.getTimeProfiler().printElapsed(startTime, "parsing " + name);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        protected final Source sourceFromURL(URL url) {
            assert (this.getContext().isOptionNashornCompatibilityMode() || this.getContext().isOptionLoadFromURL());
            try {
                return Source.newBuilder((String)"js", (URL)url).name(url.getFile()).build();
            }
            catch (IOException | SecurityException e) {
                throw JSException.create(JSErrorType.EvalError, e.getMessage(), e, this);
            }
        }

        @CompilerDirectives.TruffleBoundary
        protected final Source sourceFromFileName(String fileName, JSRealm realm) {
            try {
                return Source.newBuilder((String)"js", (TruffleFile)realm.getEnv().getPublicTruffleFile(fileName)).name(fileName).build();
            }
            catch (IOException | SecurityException e) {
                throw JSException.create(JSErrorType.EvalError, e.getMessage(), e, this);
            }
        }

        @CompilerDirectives.TruffleBoundary
        protected static final String fileGetPath(File file) {
            return file.getPath();
        }

        @Override
        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        protected Source sourceFromPath(String path, JSRealm realm) {
            Source source = null;
            JSContext ctx = this.getContext();
            if ((ctx.isOptionNashornCompatibilityMode() || ctx.isOptionLoadFromURL() || ctx.isOptionLoadFromClasspath()) && path.indexOf(58) != -1 && (source = this.sourceFromURI(path, realm)) != null) {
                return source;
            }
            try {
                TruffleFile file = GlobalBuiltins.resolveRelativeFilePath(path, realm.getEnv());
                if (file.isRegularFile(new LinkOption[0])) {
                    source = this.sourceFromTruffleFile(file);
                }
            }
            catch (SecurityException e) {
                throw Errors.createErrorFromException(e);
            }
            if (source == null) {
                throw JSLoadOperation.cannotLoadScript(path);
            }
            return source;
        }

        private Source sourceFromURI(String resource, JSRealm realm) {
            block9: {
                CompilerAsserts.neverPartOfCompilation();
                if (JSConfig.SubstrateVM) {
                    return null;
                }
                if (this.getContext().isOptionNashornCompatibilityMode() && (resource.startsWith(LOAD_NASHORN) || resource.startsWith(LOAD_CLASSPATH) || resource.startsWith(LOAD_FX)) || this.getContext().isOptionLoadFromClasspath() && resource.startsWith(LOAD_CLASSPATH)) {
                    return this.sourceFromResourceURL(resource);
                }
                if (this.getContext().isOptionNashornCompatibilityMode() || this.getContext().isOptionLoadFromURL()) {
                    try {
                        URL url = new URL(resource);
                        if ("file".equals(url.getProtocol())) {
                            String path = url.getPath();
                            if (!path.isEmpty()) {
                                try {
                                    TruffleFile file = realm.getEnv().getPublicTruffleFile(path);
                                    return this.sourceFromTruffleFile(file);
                                }
                                catch (SecurityException e) {
                                    throw Errors.createErrorFromException(e);
                                }
                            }
                            break block9;
                        }
                        return this.sourceFromURL(url);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Source sourceFromResourceURL(String resource) {
            CompilerAsserts.neverPartOfCompilation();
            assert (this.getContext().isOptionNashornCompatibilityMode() || this.getContext().isOptionLoadFromClasspath());
            InputStream stream = null;
            if (resource.startsWith(LOAD_NASHORN)) {
                if (resource.equals(NASHORN_PARSER_JS) || resource.equals(NASHORN_MOZILLA_COMPAT_JS)) {
                    stream = JSContext.class.getResourceAsStream(RESOURCES_PATH + resource.substring(LOAD_NASHORN.length()));
                }
            } else if (!JSConfig.SubstrateVM) {
                if (resource.startsWith(LOAD_CLASSPATH)) {
                    stream = ClassLoader.getSystemResourceAsStream(resource.substring(LOAD_CLASSPATH.length()));
                } else if (resource.startsWith(LOAD_FX)) {
                    stream = ClassLoader.getSystemResourceAsStream("jdk/nashorn/internal/runtime/resources/fx/" + resource.substring(LOAD_FX.length()));
                }
            }
            if (stream == null) return null;
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                Source source = Source.newBuilder((String)"js", (Reader)reader, (String)resource).build();
                return source;
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static abstract class JSFileLoadingOperation
    extends JSGlobalOperation {
        protected JSFileLoadingOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        protected Source sourceFromPath(String path, JSRealm realm) {
            Source source = null;
            try {
                TruffleFile file = GlobalBuiltins.resolveRelativeFilePath(path, realm.getEnv());
                if (file.isRegularFile(new LinkOption[0])) {
                    source = this.sourceFromTruffleFile(file);
                }
            }
            catch (SecurityException e) {
                throw Errors.createErrorFromException(e);
            }
            if (source == null) {
                throw JSFileLoadingOperation.cannotLoadScript(path);
            }
            return source;
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        protected static JSException cannotLoadScript(Object script) {
            return Errors.createTypeError("Cannot load script: " + JSRuntime.safeToString(script));
        }

        @CompilerDirectives.TruffleBoundary
        protected final Source sourceFromTruffleFile(TruffleFile file) {
            try {
                return Source.newBuilder((String)"js", (TruffleFile)file).build();
            }
            catch (IOException | SecurityException e) {
                throw JSException.create(JSErrorType.EvalError, e.getMessage(), e, this);
            }
        }
    }

    private static abstract class JSGlobalOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSToStringNode toString1Node;

        JSGlobalOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected final String toString1(Object target) {
            if (this.toString1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString1Node = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toString1Node.executeString(target);
        }
    }

    public static abstract class GlobalScriptingEXECNode
    extends JSBuiltinNode {
        public GlobalScriptingEXECNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object exec(Object cmd, Object input) {
            String cmdStr = JSRuntime.toString(cmd);
            String inputStr = input != Undefined.instance ? JSRuntime.toString(input) : null;
            return this.execIntl(cmdStr, inputStr);
        }

        @CompilerDirectives.TruffleBoundary
        private Object execIntl(String cmd, String input) {
            JSRealm realm = this.getContext().getRealm();
            TruffleLanguage.Env env = realm.getEnv();
            DynamicObject globalObj = realm.getGlobalObject();
            StringTokenizer tok = new StringTokenizer(cmd);
            String[] cmds = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                cmds[i] = tok.nextToken();
                ++i;
            }
            int exitCode = 0;
            String outStr = "";
            String errStr = "";
            Process process = null;
            try {
                TruffleProcessBuilder builder = env.newProcessBuilder(cmds);
                Object envObj = JSObject.get(globalObj, (Object)"$ENV");
                if (JSGuards.isJSObject(envObj)) {
                    DynamicObject dynEnvObj = (DynamicObject)envObj;
                    Object pwd = JSObject.get(dynEnvObj, (Object)"PWD");
                    if (pwd != Undefined.instance) {
                        builder.directory(env.getPublicTruffleFile(JSRuntime.toString(pwd)));
                    }
                    builder.clearEnvironment(true);
                    for (String key : JSObject.enumerableOwnNames(dynEnvObj)) {
                        builder.environment(key, JSRuntime.toString(JSObject.get(dynEnvObj, (Object)key)));
                    }
                }
                ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
                ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
                builder.redirectOutput(builder.createRedirectToStream((OutputStream)outBuffer));
                builder.redirectError(builder.createRedirectToStream((OutputStream)errBuffer));
                process = builder.start();
                try (OutputStreamWriter outputStream = new OutputStreamWriter(process.getOutputStream());){
                    if (input != null) {
                        outputStream.write(input, 0, input.length());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                exitCode = process.waitFor();
                outStr = outBuffer.toString();
                errStr = errBuffer.toString();
            }
            catch (InterruptedException e) {
                if (process.isAlive()) {
                    process.destroy();
                }
                if (exitCode == 0) {
                    exitCode = process.exitValue();
                }
            }
            catch (IOException | SecurityException e) {
                throw Errors.createError(e.getMessage());
            }
            JSObject.set(globalObj, "$OUT", (Object)outStr);
            JSObject.set(globalObj, "$ERR", (Object)errStr);
            JSObject.set(globalObj, "$EXIT", (Object)exitCode);
            return outStr;
        }
    }

    public static abstract class GlobalNashornExtensionParseToJSONNode
    extends JSBuiltinNode {
        public GlobalNashornExtensionParseToJSONNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String parseToJSON(Object code0, Object name0, Object location0) {
            String code = JSRuntime.toString(code0);
            String name = name0 == Undefined.instance ? "<unknown>" : JSRuntime.toString(name0);
            boolean location = JSRuntime.toBoolean(location0);
            return this.getContext().getEvaluator().parseToJSON(this.getContext(), code, name, location);
        }
    }

    public static final class GlobalNashornScriptingBuiltins
    extends JSBuiltinsContainer.SwitchEnum<GlobalNashornScripting> {
        protected GlobalNashornScriptingBuiltins() {
            super(GlobalNashornScripting.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, GlobalNashornScripting builtinEnum) {
            switch (builtinEnum) {
                case exit: 
                case quit: {
                    return GlobalBuiltinsFactory.JSGlobalExitNodeGen.create(context, builtin, GlobalNashornScriptingBuiltins.args().varArgs().createArgumentNodes(context));
                }
                case readLine: {
                    return GlobalBuiltinsFactory.JSGlobalReadLineNodeGen.create(context, builtin, GlobalNashornScriptingBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case readFully: {
                    return GlobalBuiltinsFactory.JSGlobalReadFullyNodeGen.create(context, builtin, GlobalNashornScriptingBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case parseToJSON: {
                    return GlobalBuiltinsFactory.GlobalNashornExtensionParseToJSONNodeGen.create(context, builtin, GlobalNashornScriptingBuiltins.args().fixedArgs(3).createArgumentNodes(context));
                }
                case exec: {
                    return GlobalBuiltinsFactory.GlobalScriptingEXECNodeGen.create(context, builtin, GlobalNashornScriptingBuiltins.args().fixedArgs(2).createArgumentNodes(context));
                }
                case importScriptEngineGlobalBindings: {
                    return GlobalBuiltinsFactory.JSGlobalImportScriptEngineGlobalBindingsNodeGen.create(context, builtin, GlobalNashornScriptingBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum GlobalNashornScripting implements BuiltinEnum<GlobalNashornScripting>
        {
            exit(1),
            quit(1),
            readLine(1),
            readFully(1),
            exec(1),
            parseToJSON(3),
            importScriptEngineGlobalBindings(1);

            private final int length;

            private GlobalNashornScripting(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static final class GlobalLoadBuiltins
    extends JSBuiltinsContainer.SwitchEnum<GlobalLoad> {
        protected GlobalLoadBuiltins() {
            super(GlobalLoad.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, GlobalLoad builtinEnum) {
            switch (builtinEnum) {
                case load: {
                    return GlobalBuiltinsFactory.JSGlobalLoadNodeGen.create(context, builtin, GlobalLoadBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
                }
                case loadWithNewGlobal: {
                    return GlobalBuiltinsFactory.JSGlobalLoadWithNewGlobalNodeGen.create(context, builtin, GlobalLoadBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum GlobalLoad implements BuiltinEnum<GlobalLoad>
        {
            load(1),
            loadWithNewGlobal(1);

            private final int length;

            private GlobalLoad(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static final class GlobalPrintBuiltins
    extends JSBuiltinsContainer.SwitchEnum<GlobalPrint> {
        protected GlobalPrintBuiltins() {
            super(GlobalPrint.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, GlobalPrint builtinEnum) {
            switch (builtinEnum) {
                case print: {
                    return GlobalBuiltinsFactory.JSGlobalPrintNodeGen.create(context, builtin, false, GlobalPrintBuiltins.args().varArgs().createArgumentNodes(context));
                }
                case printErr: {
                    return GlobalBuiltinsFactory.JSGlobalPrintNodeGen.create(context, builtin, true, GlobalPrintBuiltins.args().varArgs().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum GlobalPrint implements BuiltinEnum<GlobalPrint>
        {
            print(1),
            printErr(1);

            private final int length;

            private GlobalPrint(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static final class GlobalShellBuiltins
    extends JSBuiltinsContainer.SwitchEnum<GlobalShell> {
        protected GlobalShellBuiltins() {
            super(GlobalShell.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, GlobalShell builtinEnum) {
            switch (builtinEnum) {
                case quit: {
                    return GlobalBuiltinsFactory.JSGlobalExitNodeGen.create(context, builtin, GlobalShellBuiltins.args().varArgs().createArgumentNodes(context));
                }
                case readline: {
                    return GlobalBuiltinsFactory.JSGlobalReadLineNodeGen.create(context, builtin, new JavaScriptNode[]{JSConstantNode.createUndefined()});
                }
                case read: {
                    return GlobalBuiltinsFactory.JSGlobalReadFullyNodeGen.create(context, builtin, GlobalShellBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
                case readbuffer: {
                    return GlobalBuiltinsFactory.JSGlobalReadBufferNodeGen.create(context, builtin, GlobalShellBuiltins.args().fixedArgs(1).createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum GlobalShell implements BuiltinEnum<GlobalShell>
        {
            quit(1),
            readline(1),
            read(1),
            readbuffer(1);

            private final int length;

            private GlobalShell(int length) {
                this.length = length;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static enum Global implements BuiltinEnum<Global>
    {
        isNaN(1),
        isFinite(1),
        parseFloat(1),
        parseInt(2),
        encodeURI(1),
        encodeURIComponent(1),
        decodeURI(1),
        decodeURIComponent(1),
        eval(1),
        escape(1),
        unescape(1);

        private final int length;

        private Global(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isAnnexB() {
            return EnumSet.of(escape, unescape).contains(this);
        }
    }
}

