/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.pool.partition;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.pool.ObjectFactory;
import org.dromara.hutool.core.pool.ObjectPool;
import org.dromara.hutool.core.pool.Poolable;
import org.dromara.hutool.core.pool.partition.PartitionPoolConfig;
import org.dromara.hutool.core.pool.partition.PoolPartition;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.thread.ThreadUtil;

public class PartitionObjectPool<T>
implements ObjectPool<T> {
    private static final long serialVersionUID = 1L;
    private final PartitionPoolConfig config;
    private final PoolPartition<T>[] partitions;
    private boolean closed;

    public PartitionObjectPool(PartitionPoolConfig config, ObjectFactory<T> factory) {
        this.config = config;
        int partitionSize = config.getPartitionSize();
        this.partitions = new PoolPartition[partitionSize];
        for (int i = 0; i < partitionSize; ++i) {
            this.partitions[i] = new PoolPartition<T>(config, this.createBlockingQueue(config), factory);
        }
    }

    @Override
    public int getTotal() {
        int size = 0;
        for (PoolPartition<T> subPool : this.partitions) {
            size += subPool.getTotal();
        }
        return size;
    }

    @Override
    public int getIdleCount() {
        int size = 0;
        for (PoolPartition<T> subPool : this.partitions) {
            size += subPool.getIdleCount();
        }
        return size;
    }

    @Override
    public int getActiveCount() {
        int size = 0;
        for (PoolPartition<T> subPool : this.partitions) {
            size += subPool.getActiveCount();
        }
        return size;
    }

    @Override
    public T borrowObject() {
        this.checkClosed();
        return this.partitions[this.getPartitionIndex(this.config)].borrowObject();
    }

    @Override
    public PartitionObjectPool<T> returnObject(T obj) {
        this.checkClosed();
        this.partitions[this.getPartitionIndex(this.config)].returnObject((Object)obj);
        return this;
    }

    @Override
    public ObjectPool<T> free(T obj) {
        this.checkClosed();
        this.partitions[this.getPartitionIndex(this.config)].free((Object)obj);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        IoUtil.closeQuietly(this.partitions);
    }

    public String toString() {
        return StrUtil.format("PartitionObjectPool: total: {}, idle: {}, active: {}", this.getTotal(), this.getIdleCount(), this.getActiveCount());
    }

    protected BlockingQueue<Poolable<T>> createBlockingQueue(PartitionPoolConfig poolConfig) {
        return new ArrayBlockingQueue<Poolable<T>>(poolConfig.getMaxSize());
    }

    protected int getPartitionIndex(PartitionPoolConfig poolConfig) {
        return (int)(ThreadUtil.currentThreadId() % (long)poolConfig.getPartitionSize());
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Object Pool is closed!");
        }
    }
}

