/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.math.ChineseNumberFormatter;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.text.StrUtil;

public class ChineseNumberParser {
    private static final ChineseUnit[] CHINESE_NAME_VALUE = new ChineseUnit[]{new ChineseUnit(' ', 1, false), new ChineseUnit('\u5341', 10, false), new ChineseUnit('\u62fe', 10, false), new ChineseUnit('\u767e', 100, false), new ChineseUnit('\u4f70', 100, false), new ChineseUnit('\u5343', 1000, false), new ChineseUnit('\u4edf', 1000, false), new ChineseUnit('\u4e07', 10000, true), new ChineseUnit('\u4ebf', 100000000, true)};

    public static BigDecimal parseFromChinese(String chinese) {
        if (StrUtil.containsAny((CharSequence)chinese, '\u5143', '\u5706', '\u89d2', '\u5206')) {
            return ChineseNumberParser.parseFromChineseMoney(chinese);
        }
        return ChineseNumberParser.parseFromChineseNumber(chinese);
    }

    public static BigDecimal parseFromChineseNumber(String chinese) {
        Assert.notBlank(chinese, "Chinese number is blank!", new Object[0]);
        int dotIndex = chinese.indexOf(28857);
        char[] charArray = chinese.toCharArray();
        BigDecimal result = NumberUtil.toBigDecimal(ChineseNumberParser.parseLongFromChineseNumber(charArray, 0, dotIndex > 0 ? dotIndex : charArray.length));
        if (dotIndex > 0) {
            int length = chinese.length();
            for (int i = dotIndex + 1; i < length; ++i) {
                result = result.add(NumberUtil.div(ChineseNumberParser.chineseToNumber(chinese.charAt(i)), BigDecimal.TEN.pow(i - dotIndex), length - dotIndex + 1));
            }
        }
        return result.stripTrailingZeros();
    }

    public static BigDecimal parseFromChineseMoney(String chineseMoneyAmount) {
        if (StrUtil.isBlank(chineseMoneyAmount)) {
            return null;
        }
        char[] charArray = chineseMoneyAmount.toCharArray();
        int yEnd = ArrayUtil.indexOf(charArray, '\u5143');
        if (yEnd < 0) {
            yEnd = ArrayUtil.indexOf(charArray, '\u5706');
        }
        long y = 0L;
        if (yEnd > 0) {
            y = ChineseNumberParser.parseLongFromChineseNumber(charArray, 0, yEnd);
        }
        long j = 0L;
        int jEnd = ArrayUtil.indexOf(charArray, '\u89d2');
        if (jEnd > 0) {
            if (yEnd >= 0) {
                if (jEnd > yEnd) {
                    j = ChineseNumberParser.parseLongFromChineseNumber(charArray, yEnd + 1, jEnd);
                }
            } else {
                j = ChineseNumberParser.parseLongFromChineseNumber(charArray, 0, jEnd);
            }
        }
        long f = 0L;
        int fEnd = ArrayUtil.indexOf(charArray, '\u5206');
        if (fEnd > 0) {
            if (jEnd >= 0) {
                if (fEnd > jEnd) {
                    f = ChineseNumberParser.parseLongFromChineseNumber(charArray, jEnd + 1, fEnd);
                }
            } else if (yEnd > 0) {
                if (fEnd > yEnd) {
                    f = ChineseNumberParser.parseLongFromChineseNumber(charArray, yEnd + 1, fEnd);
                }
            } else {
                f = ChineseNumberParser.parseLongFromChineseNumber(charArray, 0, fEnd);
            }
        }
        BigDecimal amount = new BigDecimal(y);
        amount = amount.add(BigDecimal.valueOf(j).divide(BigDecimal.TEN, 2, RoundingMode.HALF_UP));
        amount = amount.add(BigDecimal.valueOf(f).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        return amount;
    }

    public static long parseLongFromChineseNumber(char[] chinese, int beginIndex, int toIndex) {
        long result = 0L;
        long section = 0L;
        long number = 0L;
        ChineseUnit unit = null;
        for (int i = beginIndex; i < toIndex; ++i) {
            char c = chinese[i];
            int num = ChineseNumberParser.chineseToNumber(c);
            if (num >= 0) {
                if (num == 0) {
                    if (number > 0L && null != unit) {
                        section += number * (long)(unit.value / 10);
                    }
                    unit = null;
                } else if (number > 0L) {
                    throw new IllegalArgumentException(StrUtil.format("Bad number '{}{}' at: {}", Character.valueOf(chinese[i - 1]), Character.valueOf(c), i));
                }
                number = num;
                continue;
            }
            unit = ChineseNumberParser.chineseToUnit(c);
            if (null == unit) {
                throw new IllegalArgumentException(StrUtil.format("Unknown unit '{}' at: {}", Character.valueOf(c), i));
            }
            if (unit.secUnit) {
                section = (section + number) * (long)unit.value;
                result += section;
                section = 0L;
            } else {
                long unitNumber = number;
                if (0L == number && 0 == i) {
                    unitNumber = 1L;
                }
                section += unitNumber * (long)unit.value;
            }
            number = 0L;
        }
        if (number > 0L && null != unit) {
            number *= (long)(unit.value / 10);
        }
        return result + section + number;
    }

    private static ChineseUnit chineseToUnit(char chinese) {
        for (ChineseUnit chineseNameValue : CHINESE_NAME_VALUE) {
            if (chineseNameValue.name != chinese) continue;
            return chineseNameValue;
        }
        return null;
    }

    private static int chineseToNumber(char chinese) {
        int i;
        if ('\u4e24' == chinese) {
            chinese = (char)20108;
        }
        if ((i = ArrayUtil.indexOf(ChineseNumberFormatter.DIGITS, chinese)) > 0) {
            return (i + 1) / 2;
        }
        return i;
    }

    static String getUnitName(int index, boolean isUseTraditional) {
        if (0 == index) {
            return "";
        }
        return String.valueOf(CHINESE_NAME_VALUE[index * 2 - (isUseTraditional ? 0 : 1)].name);
    }

    private static class ChineseUnit {
        private final char name;
        private final int value;
        private final boolean secUnit;

        public ChineseUnit(char name, int value, boolean secUnit) {
            this.name = name;
            this.value = value;
            this.secUnit = secUnit;
        }
    }
}

