/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.data;

import java.util.Date;
import org.dromara.hutool.core.data.CIN;
import org.dromara.hutool.core.data.CIN10;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.text.StrUtil;

public class IdcardUtil {
    public static String convert15To18(String idCard) {
        return CIN.convert15To18(idCard);
    }

    public static String convert18To15(String idCard) {
        return CIN.convert18To15(idCard);
    }

    public static boolean isValidCard(String idCard) {
        if (StrUtil.isBlank(idCard)) {
            return false;
        }
        int length = idCard.length();
        switch (length) {
            case 18: {
                return IdcardUtil.isValidCard18(idCard);
            }
            case 15: {
                try {
                    return IdcardUtil.isValidCard18(CIN.convert15To18(idCard));
                }
                catch (Exception ignore) {
                    return false;
                }
            }
            case 10: {
                return IdcardUtil.isValidCard10(idCard);
            }
        }
        return false;
    }

    public static boolean isValidCard18(String idcard) {
        return IdcardUtil.isValidCard18(idcard, true);
    }

    public static boolean isValidCard18(String idcard, boolean ignoreCase) {
        return CIN.verify(idcard, ignoreCase);
    }

    public static boolean isValidCard10(String idcard) {
        try {
            return CIN10.of(idcard).isVerified();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String getBirth(String idCard) {
        return IdcardUtil.getCIN(idCard).getBirth();
    }

    public static DateTime getBirthDate(String idCard) {
        return IdcardUtil.getCIN(idCard).getBirthDate();
    }

    public static int getAge(String idcard) {
        return IdcardUtil.getAge(idcard, DateUtil.now());
    }

    public static int getAge(String idcard, Date dateToCompare) {
        return DateUtil.age(IdcardUtil.getBirthDate(idcard), dateToCompare);
    }

    public static Short getBirthYear(String idcard) {
        return IdcardUtil.getCIN(idcard).getBirthYear();
    }

    public static Short getBirthMonth(String idcard) {
        return IdcardUtil.getCIN(idcard).getBirthMonth();
    }

    public static Short getBirthDay(String idcard) {
        return IdcardUtil.getCIN(idcard).getBirthDay();
    }

    public static int getGender(String idcard) {
        return IdcardUtil.getCIN(idcard).getGender();
    }

    public static String getProvinceCode(String idcard) {
        return IdcardUtil.getCIN(idcard).getProvinceCode();
    }

    public static String getProvince(String idcard) {
        return IdcardUtil.getCIN(idcard).getProvince();
    }

    public static String getCityCode(String idcard) {
        return IdcardUtil.getCIN(idcard).getCityCode();
    }

    public static String getDistrictCode(String idcard) {
        return IdcardUtil.getCIN(idcard).getDistrictCode();
    }

    public static String hide(String idcard, int startInclude, int endExclude) {
        return StrUtil.hide(idcard, startInclude, endExclude);
    }

    public static CIN getCIN(String idcard) {
        return CIN.of(idcard);
    }

    public static boolean isValidHkMoHomeReturn(String idCard) {
        if (StrUtil.isEmpty(idCard)) {
            return false;
        }
        String reg = "^[HhMm](\\d{8}|\\d{10})$";
        return idCard.matches("^[HhMm](\\d{8}|\\d{10})$");
    }
}

