/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl.stringer;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.function.Function;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.impl.stringer.ClobStringer;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class BlobStringer
implements Function<Object, String> {
    public static ClobStringer INSTANCE = new ClobStringer();

    @Override
    public String apply(Object o) {
        return BlobStringer.blobToStr((Blob)o);
    }

    private static String blobToStr(Blob blob) {
        String string;
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            string = IoUtil.read(in, CharsetUtil.UTF_8);
        }
        catch (SQLException e) {
            try {
                throw new ConvertException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(in);
        return string;
    }
}

